/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker.tasks.actions.controlstructures;

import com.integ.tasker.tasks.Task;
import com.integ.tasker.tasks.TaskConfiguration;
import com.integ.tasker.tasks.TaskRuntime;
import com.integ.tasker.tasks.actions.Action;
import java.util.Json;

public class ForLoop
extends Action {
    private final String _variable;
    private final Action[] _actions;

    public ForLoop(Task parentTask, Json json) {
        super(parentTask, json);
        this._variable = this._paramsJson.getString("Variable");
        this._actions = super.getActions("Actions");
        System.out.println("for loop " + this._actions.length + " actions");
    }

    @Override
    public void execute(TaskRuntime taskRuntime) throws Throwable {
        try {
            int from = this.getIntParam("From", taskRuntime);
            int to = this.getIntParam("To", taskRuntime);
            boolean ascending = to >= from;
            boolean doSleep = false;
            if (ascending) {
                for (int i = from; i <= to; ++i) {
                    if (doSleep) {
                        Thread.sleep(50L);
                    }
                    doSleep = true;
                    taskRuntime.Scope.setVariable(this._variable, i);
                    for (Action action : this._actions) {
                        TaskConfiguration.LOG.info(String.format("   action: %s", action.toString()));
                        action.execute(taskRuntime);
                    }
                }
            } else {
                for (int i = from; i >= to; --i) {
                    if (doSleep) {
                        Thread.sleep(50L);
                    }
                    doSleep = true;
                    taskRuntime.Scope.setVariable(this._variable, i);
                    for (Action action : this._actions) {
                        TaskConfiguration.LOG.info(String.format("   action: %s", action.toString()));
                        action.execute(taskRuntime);
                    }
                }
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            throw new Exception("error executing for loop").initCause(ex);
        }
    }
}

