/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.tasker;

import com.integpg.tasker.ast.ASTNode;
import com.integpg.tasker.ast.ASTParser;

public class ExpressionTests {
    public static void doTests() {
        long start = System.currentTimeMillis();
        ExpressionTests.testExpression("Temp[1].fahrenheit - tEmP[1].F");
        ExpressionTests.testExpression("-10 + (7.5 - (7.5 - 2.5)) * 10 / 2");
        ExpressionTests.testExpression("true");
        ExpressionTests.testExpression("false");
        ExpressionTests.testExpression("!false");
        ExpressionTests.testExpression("true == true");
        ExpressionTests.testExpression("false == false");
        ExpressionTests.testExpression("true == false");
        ExpressionTests.testExpression("true != false");
        ExpressionTests.testExpression("3 < 4 && 3 > 4");
        ExpressionTests.testExpression("3 == 3");
        ExpressionTests.testExpression("3 == 4");
        ExpressionTests.testExpression("3 != 3");
        ExpressionTests.testExpression("3 != 4");
        ExpressionTests.testExpression("Temp[1].fahrenheit > 78");
        ExpressionTests.testExpression("din[1].state == 1");
        ExpressionTests.testExpression("((din[1].state == 1) && (din[2].state != 1)) || (din[5].state == 1)");
        ASTParser.setDebug(true);
        ExpressionTests.testExpression("(din[1].state && din[2].state) || din[5].state");
        ExpressionTests.testExpression("date.isDay(tuewedthu)");
        ExpressionTests.testExpression("time.after(9:00)");
        ExpressionTests.testExpression("time.before(14:55)");
        ExpressionTests.testExpression("time.after(9:00) && time.before(17:00)");
        long elapsed = System.currentTimeMillis() - start;
        System.out.println("expression tests elapsed: " + elapsed);
    }

    private static void testExpression(String expressionString) {
        try {
            System.out.println("\r\n" + expressionString + " test");
            ASTParser expressionParser = new ASTParser(expressionString, null);
            ASTNode expressionNode = expressionParser.parse();
            System.out.println("expressionNode: " + expressionParser.getExpressionString() + " = " + expressionNode.evaluate());
            System.out.println("");
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
        }
    }
}

