/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.tasker;

import com.integpg.janoslib.io.AppLog;
import com.integpg.janoslib.text.QuickDateFormat;
import com.integpg.tasker.ExpressionReplacer;
import com.integpg.tasker.ast.ASTNode;
import com.integpg.tasker.ast.ASTParser;
import java.text.DecimalFormat;
import java.util.regex.Pattern;

public class ExpressionStatementReplacer
extends ExpressionReplacer {
    private static final QuickDateFormat QUICK_DATE_FORMAT = new QuickDateFormat("MM/dd/yy HH:mm:ss.fff");
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("0.00");

    public ExpressionStatementReplacer(String original) {
        super(original);
        ReplacePattern = Pattern.compile("{{[\\w()\\\\. -]*}}");
    }

    public String replace() {
        return this.replace(this._original);
    }

    @Override
    public String replace(String replaceString) {
        System.out.println("ExpressionStatementReplacer.replace called: " + replaceString);
        switch (replaceString) {
            case "milliseconds": {
                return Long.toString(System.currentTimeMillis());
            }
            case "timestamp": {
                return QUICK_DATE_FORMAT.format(System.currentTimeMillis());
            }
        }
        try {
            ASTParser expressionParser = new ASTParser(replaceString, null);
            ASTNode expressionNode = expressionParser.parse();
            Object result = expressionNode.evaluate();
            System.out.println("expressionNode: " + expressionParser.getExpressionString() + " = " + result);
            System.out.println("");
            if (result instanceof Double) {
                if (Double.isNaN((Double)result)) {
                    return "null";
                }
                return DECIMAL_FORMAT.format(result);
            }
            return String.valueOf(result);
        }
        catch (Exception ex) {
            AppLog.error(ex);
            return "";
        }
    }

    @Override
    public String toString() {
        return this._original + " = " + this.evaluate();
    }
}

