/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker.devices;

import com.integ.tasker.devices.DeviceProfile;
import com.integ.tasker.devices.RecvDevice;
import com.integ.tasker.devices.SendDevice;
import com.integ.tasker.web.messages.ErrorMessage;
import com.integpg.comm.AUXSerialPort;
import com.integpg.comm.COMSerialPort;
import com.integpg.comm.SerialPort;
import com.integpg.janoslib.messagepump.MessagePumpEngine;
import com.integpg.janoslib.utils.HexUtils;
import java.io.DataInputStream;
import java.io.InputStream;
import java.util.Json;

public class SerialDevice
extends DeviceProfile
implements SendDevice,
RecvDevice {
    private static AUXSerialPort AuxSerialPort;
    private static COMSerialPort ComSerialPort;
    private String _port;
    private SerialPort _serialPort;

    public SerialDevice(Json json) {
        super(json);
        try {
            Json paramsJson = (Json)json.get("Params");
            this._port = paramsJson.getString("Port");
            LOG.info(String.format("Serial Device: port: %s", this._port));
            if ("aux".equalsIgnoreCase(this._port)) {
                if (null == AuxSerialPort) {
                    AuxSerialPort = new AUXSerialPort();
                    AuxSerialPort.open();
                }
                this._serialPort = AuxSerialPort;
            } else if ("com".equalsIgnoreCase(this._port)) {
                if (null == ComSerialPort) {
                    ComSerialPort = new COMSerialPort();
                    ComSerialPort.open();
                }
                this._serialPort = new COMSerialPort();
            } else {
                new RuntimeException("unknown serial port type: " + this._port);
            }
        }
        catch (Throwable ex) {
            Throwable throwable = new Exception("unable to load " + this.Name).initCause(ex);
            LOG.error(throwable);
            ErrorMessage message = new ErrorMessage(throwable);
            MessagePumpEngine.postMessage(message.build());
        }
    }

    public String getPort() {
        return this._port;
    }

    @Override
    public void send(byte[] bytes) throws Exception {
        try {
            LOG.info(String.format("sending '%s' to %s", new String(bytes), this._serialPort.toString()));
            this._serialPort.getOutputStream().write(bytes);
            this._serialPort.getOutputStream().flush();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.close();
        }
    }

    @Override
    public byte[] receive() throws Exception {
        try {
            DataInputStream dis = new DataInputStream((InputStream)this._serialPort.getInputStream());
            byte[] newArray = new byte[dis.available()];
            int bytesRead = dis.read(newArray);
            DeviceProfile.LOG.info(String.format("%s read %d bytes: %s", this.Name, bytesRead, HexUtils.bytesToHex(newArray)));
            return newArray;
        }
        catch (Exception ex) {
            this.close();
            throw ex;
        }
    }

    public void close() throws Exception {
    }
}

