/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.janoslib.net.http.server;

import com.integpg.janoslib.net.http.server.HttpRequest;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Hashtable;

public class HttpResponse {
    private final HttpRequest _httpRequest;
    private String _contentType = "text/plain";
    private final PrintWriter _printWriter;
    private final ByteArrayOutputStream _byteArrayOutputStream = new ByteArrayOutputStream();

    public HttpResponse(HttpRequest httpRequest) throws IOException {
        this._httpRequest = httpRequest;
        this._printWriter = new PrintWriter(new OutputStreamWriter(this._byteArrayOutputStream));
    }

    public void setContentType(String contentType) {
        this._contentType = contentType;
    }

    public PrintWriter getWriter() {
        return this._printWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendResponse(int code) {
        Hashtable<String, String> headers = this._httpRequest.getHeaderCollection();
        try {
            DataOutputStream dataOutputStream = new DataOutputStream(this._httpRequest.getOutputStream());
            dataOutputStream.writeBytes(String.format("%s %d OK\r\n", this._httpRequest.getHttpVersion(), code));
            if (null != headers.get("Connection")) {
                dataOutputStream.writeBytes(String.format("Connection: %s\r\n", headers.get("Connection")));
            }
            dataOutputStream.writeBytes(String.format("Content-Type: %s\r\n", this._contentType));
            dataOutputStream.writeBytes(String.format("Date: %s\r\n", new Date().toString()));
            dataOutputStream.writeBytes("Server: JANOSLib\r\n");
            dataOutputStream.writeBytes("Access-Control-Allow-Origin: *\r\n");
            this._printWriter.flush();
            int contentLength = this._byteArrayOutputStream.size();
            dataOutputStream.writeBytes(String.format("Content-Length: %d\r\n", contentLength));
            dataOutputStream.writeBytes("\r\n");
            dataOutputStream.write(this._byteArrayOutputStream.toByteArray());
            dataOutputStream.flush();
        }
        catch (IOException ex) {
            ex.printStackTrace();
            try {
                this._httpRequest.close();
            }
            catch (IOException ex2) {
                ex2.printStackTrace();
            }
        }
        finally {
            if (!"keep-alive".equalsIgnoreCase(headers.get("Connection"))) {
                try {
                    this._httpRequest.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }
}

