/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker.triggers.triggertypes;

import com.integ.tasker.TaskerMain;
import com.integ.tasker.Unloadable;
import com.integ.tasker.triggers.Trigger;
import com.integ.tasker.workspaces.WorkspaceFile;
import com.integpg.janoslib.externalio.controlpanel.ControlPanel;
import com.integpg.janoslib.externalio.controlpanel.ControlPanelListener;
import java.util.Json;

public class ControlPanelMultiSwitchTrigger
extends Trigger
implements ControlPanelListener,
Unloadable {
    private final int _pattern;

    public ControlPanelMultiSwitchTrigger(Json triggerJson) {
        Json paramsJson = (Json)triggerJson.get("Params");
        int switch1 = paramsJson.getInt("Switch1");
        int switch2 = paramsJson.getInt("Switch2");
        this._pattern = 1 << switch1 - 1 | 1 << switch2 - 1;
        System.out.printf("ControlPanelMultiSwitchTrigger switch1 = %d, switch2 = %d, pattern = 0x%02x\n", new Object[]{switch1, switch2, this._pattern});
        ControlPanel controlPanel = TaskerMain.getControlPanel();
        controlPanel.addListener(this);
        controlPanel.monitorSwitches();
    }

    @Override
    public void setWorkspaceConfigurationFile(WorkspaceFile workspaceConfigurationFile) {
        super.setWorkspaceConfigurationFile(workspaceConfigurationFile);
        workspaceConfigurationFile.addUnloadable(this);
    }

    @Override
    public boolean switchesPressed(Object source, int channelMask) {
        System.out.println(String.format("%s.switchesPressed: 0x%02x", this.toString(), channelMask));
        if (channelMask == this._pattern) {
            this.trigger();
        }
        return true;
    }

    @Override
    public boolean switchPressed(Object source, int channel, int count) {
        return true;
    }

    @Override
    public void unload() {
        TaskerMain.getControlPanel().removeListener(this);
    }
}

