var app = angular.module('TaskerHelp', []);

app.controller('HelpController', function ($scope, $location, $sce) {
    var _this = this;
    _this.Version = "12.0";
    _this.order = 'Title';
    _this.search = {};


    _this.GetWebSafe = function (string) {
        // remove '...'
        var webSafe = string.replace('...', '');
        // replace non web safe characters with underscores
        var search = /[ @\.\/\-:]/;
        var replacement = '_';
        webSafe = webSafe.replace(new RegExp(search, 'g'), replacement);
        var search = />/;
        var replacement = '-';
        webSafe = webSafe.replace(new RegExp(search, 'g'), replacement);
        // replace multiple underscores with one underscore
        webSafe = webSafe.replace(new RegExp(/_+/, 'g'), '_');
        // we wont lowercase
        webSafe = webSafe.toLowerCase();
        return webSafe;
    };


    _this.trustAsHtml = function (string) {
        return $sce.trustAsHtml(string);
    };


    _this.Topics = [
        { Title: "Introduction", Source: "introduction.html" },
        {
            Title: "Main Menu", Source: "main-menu.html", Topics: [
                {
                    Title: "File Menu", Source: "file-menu.html", Topics: [
                        { Title: "File > New" },
                        { Title: "File > Open" },
                        { Title: "File > Save" },
                        { Title: "File > Save As..." },
                        { Title: "File > Clone..." },
                        { Title: "File > Rename..." },
                        { Title: "File > Edit Notes..." },
                        { Title: "File > Close" },
                        { Title: "File > Revert" },
                        { Title: "File > Restore" },
                        { Title: "File > Enable / Disable" },
                        { Title: "File > Delete" },
                        { Title: "File > Preferences" },
                        { Title: "File > Upload" },
                        { Title: "File > Download" }
                    ]
                },
                {
                    Title: "Tools Menu", Source: "tools-menu.html", Topics: [
                        { Title: "Tools > Web UI - JNIOR Configuration" },
                        { Title: "Tools > Grapher" },
                        { Title: "Tools > Grapher Configuration" }
                    ]
                },
                {
                    Title: "Help Menu", Source: "help-menu.html", Topics: [
                        { Title: "Help > Help" },
                        { Title: "Help > Knowledgebase" },
                        { Title: "Help > Contact Us" },
                        { Title: "Help > Show Log" }
                    ]
                }
            ]
        },
        { Title: "Status Bar", Source: "status-bar.html" },
        {
            Title: "Workspaces View", Source: "workspaces.html", Topics: [
                { Title: "Create a Workspace" },
                { Title: "Uploading a Workspace" },
                { Title: "Downloading a Workspace" },
                { Title: "Cloning a Workspace" },
                { Title: "Removing a Workspace" },
                { Title: "Enabling / Disabling a Workspace" },
                { Title: "Renaming a Workspace" },
                { Title: "Editing Notes for a Workspace" },
                { Title: "Open a Workspace" }
            ]
        },
        {
            Title: "Active Workspace View", Source: "active-workspace.html", Topics: [
                { Title: "Workspaces Pane", Source: "workspaces-pane.html" },
                {
                    Title: "Tasks Tab", Source: "tasks-tab.html", Topics: [
                        { Title: "Adding a Task" },
                        { Title: "Removing a Task" },
                        { Title: "Reordering a Task" },
                        { Title: "Cloning a Task" },
                        { Title: "Executing a Task" },
                        { Title: "Renaming a Task" },
                        { Title: "Selecting a Task" },
                        { Title: "Adding an Action" },
                        { Title: "Removing an Action" },
                        { Title: "Reordering an Action" },
                        { Title: "Cloning an Action"}
                    ]
                },
                {
                    Title: "Devices Tab", Source: "devices-tab.html", Topics: [
                        { Title: "Adding a Device" },
                        { Title: "Removing a Device" },
                        { Title: "Reordering a Device" },
                        { Title: "Renaming a Device" },
                        {
                            Title: "Device Types", Source: "device-types.html", Topics: [
                                { Title: "Ethernet Device" },
                                { Title: "SNMP Device" }
                            ]
                        }
                    ]
                },
                {
                    Title: "Loggers Tab", Source: "loggers-tab.html", Topics: [
                        { Title: "Adding a Logger" },
                        { Title: "Removing a Logger" },
                        { Title: "Reordering a Logger" },
                        { Title: "Renaming a Logger" },
                        { Title: "Entering a File Name" },
                        { Title: "Entering a Header" },
                        { Title: "Entering a Timestamp" },
                        { Title: "Entering Log Values" }
                    ]
                },
                {
                    Title: "Signals Tab", Source: "signals-tab.html", Topics: [
                        { Title: "Adding a Signal" },
                        { Title: "Removing a Signal" },
                        { Title: "Reordering a Signal" },
                        { Title: "Renaming a Signal" },
                        {
                            Title: "Signal Types", Source: "signal-types.html", Topics: [
                                { Title: "Digital Inputs" },
                                { Title: "Relay Outputs" },
                                { Title: "Temperature Probe" },
                                { Title: "Environmental Sensor" },
                                { Title: "4-20ma Inputs" },
                                { Title: "4-20ma Outputs" },
                                { Title: "10volt Inputs" },
                                { Title: "10volt Outputs" },
                            ]
                        }
                    ]
                },
                {
                    Title: "Triggers Tab", Source: "triggers-tab.html", Topics: [
                        { Title: "Adding a Trigger" },
                        { Title: "Removing a Trigger" },
                        { Title: "Reordering a Trigger" },
                        { Title: "Renaming a Trigger" },
                        {
                            Title: "Trigger Types", Source: "trigger-types.html", Topics: [
                                { Title: "Discrete Trigger" },
                                { Title: "Continuous Trigger" },
                                { Title: "Expression Evaluation" },
                                { Title: "Single Control Panel Switch Trigger" },
                                { Title: "Multiple Control Panel Switch Trigger" },
                                { Title: "Modbus Tag Update" },
                            ]
                        }
                    ]
                },
                {
                    Title: "Schedules Tab", Source: "schedules-tab.html", Topics: [
                        { Title: "Adding a Schedule" },
                        { Title: "Removing a Schedule" },
                        { Title: "Reordering a Schedule" },
                        { Title: "Renaming a Schedule" },
                        { Title: "Enable/Disable a Schedule" },
                        { Title: "Adding a Rule" },
                        {
                            Title: "Rule Types", Source: "rule-types.html", Topics: [
                                { Title: "On Boot" },
                                { Title: "Sunrise" },
                                { Title: "Sunset" },
                                { Title: "Schedule" }
                            ]
                        }
                    ]
                }
            ]
        },
        {
            Title: "Task Actions", Source: "task-actions.html", Topics: [
                {
                    Title: "Relay Output Actions", Source: "relayoutput-actions.html", Topics: [
                        {
                            Title: "Close Relay", Source: "relayoutputs-closerelay.html", Arguments: [
                                { Name: "Channel", Type: "Number", Notes: "The number has to be one of the available outputs on the JNIOR." },
                            ]
                        },
                        { 
                            Title: "Open Relay", Source: "relayoutputs-openrelay.html", Arguments: [
                                { Name: "Channel", Type: "Number", Notes: "The number has to be one of the available outputs on the JNIOR." },
                            ] 
                        },
                        { 
                            Title: "Toggle Relay", Source: "relayoutputs-togglerelay.html", Arguments: [
                                { Name: "Channel", Type: "Number", Notes: "The number has to be one of the available outputs on the JNIOR." },
                            ]  
                        },
                        { 
                            Title: "Set Relay State", Source: "relayoutputs-setrelay.html", Arguments: [
                                { Name: "Channel", Type: "Boolean", Notes: "Can be set to either HIGH(Closed) or LOW(Open)" },
                            ]  
                        },
                        { 
                            Title: "Set Relays", Source: "relayoutputs-setrelays.html", Arguments: [
                                { Name: "Channel Mask", Type: "Number or Hex", Notes: "This selects what outputs you are referencing to set their state." },
                                { Name: "State Mask", Type: "Number or Hex", Notes: "This gets compared to the state mask, and sets the channels states accordingly." },
                            ]  
                        },
                        { 
                            Title: "Pulse Relay", Source: "relayoutputs-pulserelay.html", Arguments: [
                                { Name: "Channel", Type: "Number", Notes: "The number has to be one of the available outputs on the JNIOR." },
                                { Name: "Time", Type: "Number", Notes: "Amount of time the relay should pulse for." },
                            ] 
                        },
                        { 
                            Title: "Pulse Relays", Source: "relayoutputs-pulserelays.html", Arguments: [
                                { Name: "Channel Mask", Type: "Number or Hex", Notes: "This selects what outputs you are referencing to set their state." },
                                { Name: "State Mask", Type: "Number or Hex", Notes: "This gets compared to the state mask, and sets the channels states accordingly." },
                                { Name: "Time", Type: "Number", Notes: "Amount of time the relay should pulse for." },
                            ]  
                        },
                        { 
                            Title: "Reset Output Usage Meter", Source: "relayoutputs-resetoutputusagemeter.html", Arguments: [
                                { Name: "Channel", Type: "Number", Notes: "The number has to be one of the available outputs on the JNIOR." },
                            ]   
                        }
                    ]
                },
                {
                    Title: "Digital Input Actions", Source: "digitalinput-actions.html", Topics: [
                        { 
                            Title: "Set Conditioning State", Source: "digitalinputs-setconditioningstate.html", Arguments: [
                                { Name: "Channel", Type: "Number", Notes: "The number has to be one of the available inputs on the JNIOR." },
                                { Name: "State", Type: "Dropdown", Notes: "'Invert' is the opposite of the inputs current state." },
                            ]    
                        },
                        {
                            Title: "Soft Invert Input", Source: "digitalinputs-softinputinvert.html", Arguments: [
                                { Name: "Channel", Type: "Number", Notes: "The number has to be one of the available inputs on the JNIOR." },
                                { Name: "Inversion", Type: "Checkbox", Notes: "If checked, the input gets inverted. If unchecked, removes inversion from the input." },
                            ]    
                        },
                        { 
                            Title: "Set Input Counter", Source: "digitalinputs-setinputcounter.html", Arguments: [
                                { Name: "Channel", Type: "Number", Notes: "The number has to be one of the available inputs on the JNIOR." },
                                { Name: "Counter", Type: "Number", Notes: "The number you want to set the counter value for the input to." },
                            ]     
                        },
                        {
                            Title: "Reset Input Usage Meter", Source: "digitalinputs-resetinputusagemeter.html", Arguments: [
                                { Name: "Channel", Type: "Number", Notes: "The number has to be one of the available inputs on the JNIOR." },
                            ]     
                        },
                        {
                            Title: "Clear Input Latch", Source: "digitalinputs-clearinputlatch.html", Arguments: [
                                { Name: "Channel", Type: "Number", Notes: "The number has to be one of the available inputs on the JNIOR." },
                            ]    
                        },
                        {
                            Title: "Soft Pulse Input", Source: "digitalinputs-softpulseinput.html", Arguments: [
                                { Name: "Channel", Type: "Number", Notes: "The number has to be one of the available inputs on the JNIOR." },
                                { Name: "Time", Type: "Number", Notes: "Amount of time the relay should pulse for." },
                            ]     
                        }
                    ]
                },
                {
                    Title: "Analog Output Actions", Source: "analogoutput-actions.html", Topics: [
                        {
                            Title: "Set 10v Percentage", Source: "analogoutputs-set10vpercentage.html", Arguments: [
                                { Name: "Channel", Type: "Number", Notes: "The number has to be one of the available outputs on the 10v Module." },
                                { Name: "Percent", Type: "Number", Notes: "Sets amount of voltage on the output as a percent from 0 - 100" },
                            ]     
                        },
                        {
                            Title: "Set 10v Voltage", Source: "analogoutputs-set10vvoltage.html", Arguments: [
                                { Name: "Channel", Type: "Number", Notes: "The number has to be one of the available outputs on the 10v Module." },
                                { Name: "Voltage", Type: "Number", Notes: "Sets amount of voltage on the output in voltage from 0 - 10" },
                            ]    
                        },
                        {
                            Title: "Fade 10v Percentage", Source: "analogoutputs-fade10vpercentage.html", Arguments: [
                                { Name: "Channel", Type: "Number", Notes: "The number has to be one of the available outputs on the 10v Module." },
                                { Name: "Percent", Type: "Number", Notes: "Sets amount of voltage on the output in voltage from 0 - 10" },
                                { Name: "Time", Type: "Number", Notes: "The amount of time it will take to gradually change the percent of the output to it's new value." },
                            ]    
                        },
                        {
                            Title: "Fade 10v Voltage", Source: "analogoutputs-fade10vvoltage.html", Arguments: [
                                { Name: "Channel", Type: "Number", Notes: "The number has to be one of the available outputs on the 10v Module." },
                                { Name: "Voltage", Type: "Number", Notes: "Sets amount of voltage on the output in voltage from 0 - 10" },
                                { Name: "Time", Type: "Number", Notes: "The amount of time it will take to gradually change the voltage of the output to it's new value." },
                            ]    
                        },
                        {
                            Title: "Set 4-20ma Percentage", Source: "analogoutputs-set420mapercentage.html", Arguments: [
                                { Name: "Channel", Type: "Number", Notes: "The number has to be one of the available outputs on the 4-20ma Module." },
                                { Name: "Percent", Type: "Number", Notes: "Sets amount of amps on the output as a percent from 0 - 100" },
                            ]    
                        },
                        {
                            Title: "Set 4-20ma Amps", Source: "analogoutputs-set420maamps.html", Arguments: [
                                { Name: "Channel", Type: "Number", Notes: "The number has to be one of the available outputs on the 4-20ma Module." },
                                { Name: "Percent", Type: "Number", Notes: "Sets amount of amps on the output in amperage from 4 - 20" },
                            ]    
                        }
                    ]
                },
                {
                    Title: "Control Panel Actions", Source: "controlpanel-actions.html", Topics: [
                        {
                            Title: "Set LED", Source: "controlpanel-setled.html", Arguments: [
                                { Name: "Channel", Type: "Number", Notes: "The number has to be one of the available LEDs on the Control Panel." },
                                { Name: "Speed", Type: "Number", Notes: "Sets the speed that the LED blinks." },
                            ]    
                        },
                        {
                            Title: "Play Alarm", Source: "controlpanel-playalarm.html", Arguments: [
                                { Name: "Speed", Type: "Number", Notes: "How fast the alarm will sound when running." },
                                { Name: "Time", Type: "Number", Notes: "How long the alarm will sound for." },
                                { Name: "Volume", Type: "Number", Notes: "How loud the alarm will be from 0 - 100" },
                                { Name: "Frequency", Type: "Number", Notes: "If custom speed is selected, this sets the frequency of the alarm from 1 - 96." },
                                { Name: "Frequency Duration", Type: "Number", Notes: "If custom speed is selected, this sets the timing of frequency for the alarm." },
                            ]    
                        },
                        {
                            Title: "Silence Alarm", Source: "controlpanel-silencealarm.html", Arguments: [
                                {Notes: "Will silence the alarm if its actively running." },
                            ]    
                        }
                    ]
                },
                {
                    Title: "Control Structure Actions", Source: "controlstructure-actions.html", Topics: [
                        {
                            Title: "If Block", Source: "controlstructures-ifblock.html", Arguments: [
                                { Name: "Expression", Type: "Boolean", Notes: "Whatever value is entered must be able to evaluate as either true or false." },
                            ]
                        },
                        {
                            Title: "If:Else Block", Source: "controlstructures-ifelseblock.html", Arguments: [
                                { Name: "Expression 1", Type: "Boolean", Notes: "Whatever value is entered must be able to evaluate as either true or false." },
                                { Name: "Expression 2", Type: "Boolean", Notes: "This expression resolves if the first one returned false." },
                            ]     
                        },
                        {
                            Title: "For Loop", Source: "controlstructures-loop.html", Arguments: [
                                { Name: "Expression", Type: "Number", Notes: "This value will match the current iteration of the loop." },
                                { Name: "Loop start", Type: "Number", Notes: "This is the value that the loop will start at." },
                                { Name: "Loop end", Type: "Number", Notes: "This is the value that the loop will end at." },
                            ] 
                        },
                        {
                            Title: "While Loop", Source: "controlstructures-whileloop.html", Arguments: [
                                { Name: "Expression", Type: "Boolean", Notes: "Whatever value is entered must be able to evaluate as either true or false." },
                            ]
                        }
                    ]
                },
                {
                    Title: "File Actions", Source: "file-actions.html", Topics: [
                        {
                            Title: "File Delete", Source: "file-deletefile.html", Arguments: [
                                { Name: "File Name", Type: "String", Notes: "The source file path of the file to delete." },
                            ] 
                        },
                        {
                            Title: "File Prepend", Source: "file-prependfile.html", Arguments: [
                                { Name: "File Name", Type: "String", Notes: "The source file path of the file that will get prepended." },
                                { Name: "Data", Type: "String", Notes: "This is the text that will get prepended to the file." },
                            ]
                        },
                        {
                            Title: "File Copy", Source: "file-copyfile.html", Arguments: [
                                { Name: "File Name", Type: "String", Notes: "The source file path of the file to copy." },
                                { Name: "File Destination", Type: "String", Notes: "The destination file path where the file will be copied to." },
                            ]
                        },
                        {
                            Title: "File Move", Source: "file-movefile.html", Arguments: [
                                { Name: "File Name", Type: "String", Notes: "The source file path of the file to move." },
                                { Name: "File Destination", Type: "String", Notes: "The destination file path where the file will be moved to." },
                            ]
                        },
                        {
                            Title: "Log Entry", Source: "logging-logentry.html", Arguments: [
                                { Name: "File Name", Type: "String", Notes: "The source file path of the file that will be logged. Creates a new file at that location if one doesn't exist." },
                                { Name: "Data", Type: "String", Notes: "The text that will be logged to the file." },
                            ] 
                        },
                        {
                            Title: "Log Profile", Source: "logging-logprofile.html", Arguments: [
                                { Name: "Log Profile Name", Type: "String", Notes: "The name of a logger in the Logger Tab that will activate from this action." },
                            ]
                        }
                    ]
                },
                {
                    Title: "Other Actions", Source: "other-actions.html", Topics: [
                        {
                            Title: "Comment", Source: "other-comment.html", Arguments: [
                                { Name: "Comment", Type: "String", Notes: "Text for the comment." },
                            ] 
                        },
                        {
                            Title: "Command Line", Source: "other-commandline.html", Arguments: [
                                { Name: "Command", Type: "String", Notes: "The telnet command that will be executed." },
                            ] 
                             
                        },
                        {
                            Title: "Reboot", Source: "other-reboot.html", Arguments: [
                                { Notes: "Reboot will immediately take effect when this actions executes." },
                            ] 
                        },
                        {
                            Title: "Execute Task", Source: "other-executetask.html", Arguments: [
                                { Name: "Task", Type: "String", Notes: "The task in the workspace you want to execute from this action." },
                            ] 
                        },
                        {
                            Title: "Cancel Task", Source: "other-canceltask.html", Arguments: [
                                { Name: "Task", Type: "String", Notes: "Stops the task whos name is entered here if its currently running." },
                            ]  
                        },
                        {
                            Title: "Execute Script", Source: "other-executescript.html", Arguments: [
                                { Name: "commands", Type: "String", Notes: "Evaluates expressions entered here." },
                            ]  
                        },
                        { 
                            Title: "User Alert", Source: "other-useralert.html", Arguments: [
                                { Name: "Alert", Type: "String", Notes: "Text that will be displayed in the alert." },
                            ]  
                        },
                        {
                            Title: "Registry Write", Source: "other-registrywrite.html", Arguments: [
                                { Name: "Registry Key", Type: "String", Notes: "Pathing of the registry key on the JNIOR. Will create a key if it doesn't exist." },
                                { Name: "Data", Type: "String", Notes: "Value that will be entered into the registry key." },
                            ]
                        },
                        {
                            Title: "Set Variable", Source: "other-setvariable.html", Arguments: [
                                { Name: "Name", Type: "String", Notes: "The name you are assigning the value." },
                                { Name: "Data", Type: "String", Notes: "Value that the variable will reference." },
                            ]  
                        }
                    ]
                },
                {
                    Title: "Timing Actions", Source: "timing-actions.html", Topics: [
                        { Title: "At (Not Yet Implemented)", Source: "not-yet-implemented.html" },
                        {
                            Title: "Sleep", Source: "timing-sleep.html", Arguments: [
                                { Name: "Time", Type: "Number", Notes: "Amount in seconds that the task will wait before continuing when this action executes." },
                            ]   
                        }
                    ]
                },
                {
                    Title: "Lighting Actions", Source: "lighting-actions.html", Topics: [
                        {
                            Title: "Set LED Channel", Source: "lighting-setdimmerchannel.html", Arguments: [
                                { Name: "Channel", Type: "Number", Notes: "The number has to be one of the available outputs on the 3 Channel Dimmer." },
                                { Name: "Percent", Type: "Number", Notes: "The amperage supplied to the output." },
                            ]   
                        },
                        {
                            Title: "Set LED RGB", Source: "lighting-setdimmerrgb.html", Arguments: [
                                { Name: "Dimmer", Type: "Number", Notes: "Specifies which dimmer is being controlled." },
                                { Name: "Channel 1 amperage", Type: "Number", Notes: "The ameperage supplied to output 1." },
                                { Name: "Channel 2 amperage", Type: "Number", Notes: "The ameperage supplied to output 2." },
                                { Name: "Channel 3 amperage", Type: "Number", Notes: "The ameperage supplied to output 3." },
                            ]   
                        },
                        {
                            Title: "Fade LED Channel", Source: "lighting-fadedimmerchannel.html", Arguments: [
                                { Name: "Channel", Type: "Number", Notes: "The number has to be one of the available outputs on the 3 Channel Dimmer." },
                                { Name: "Percent", Type: "Number", Notes: "The amperage supplied to the output." },
                                { Name: "Time", Type: "Number", Notes: "The amount of time it will take to gradually change the amperage of the output to it's new value." },

                            ]   
                        },
                        {
                            Title: "Fade LED RGB", Source: "lighting-fadedimmerrgb.html", Arguments: [
                                { Name: "Dimmer", Type: "Number", Notes: "Specifies which dimmer is being controlled." },
                                { Name: "Channel 1 amperage", Type: "Number", Notes: "The ameperage supplied to output 1." },
                                { Name: "Channel 2 amperage", Type: "Number", Notes: "The ameperage supplied to output 2." },
                                { Name: "Channel 3 amperage", Type: "Number", Notes: "The ameperage supplied to output 3." },
                                { Name: "Time", Type: "Number", Notes: "The amount of time it will take to gradually change the amperage of the outputs to their new values." },
                            ]   
                        }
                    ]
                },
                {
                    Title: "Communication Actions", Source: "communication-actions.html", Topics: [
                        {
                            Title: "Device Send", Source: "communication-devicesend.html", Arguments: [
                                { Name: "Device", Type: "Dropdown", Notes: "A device from your device tab you wish to send to." },
                                { Name: "Data", Type: "Number", Notes: "The data you want to send to the device." },
                                { Name: "Response Check", Type: "Checkbox", Notes: "If checked will allow you to recieve a response back from the device you sent to." },
                                { Name: "Response Name", Type: "String", Notes: "Name for a variable that will reference the response data." },
                                { Name: "Data Type", Type: "Dropdown", Notes: "Assign the data for the response as either bytes or string." },
                            ]
                        },
                        {
                            Title: "TCP Close", Source: "communication-tcpclose.html", Arguments: [
                                { Name: "Device", Type: "Dropdown", Notes: "Device from the device tab that will have its connection closed." },
                            ]    
                        },
                        {
                            Title: "HTTP Request", Source: "communication-httprequest.html", Arguments: [
                                { Name: "Request", Type: "String", Notes: "Text that will be used for the HTTP Request." },
                            ]   
                        },
                        {
                            Title: "HTTP Post", Source: "communication-httppost.html", Arguments: [
                                { Name: "URL", Type: "String", Notes: "URL for the HTTP Post." },
                                { Name: "Command", Type: "String", Notes: "command for the HTTP Post." },
                            ]   
                        },
                        {
                            Title: "Email Send", Source: "communication-emailsend.html", Arguments: [
                                { Name: "Email Address", Type: "String", Notes: "URL for the HTTP Post." },
                                { Name: "CC", Type: "String", Notes: "Emails that will recieve carbon copies of the email." },
                                { Name: "BCC", Type: "String", Notes: "Emails that will recieve blind carbon copies of the email." },
                                { Name: "Subject", Type: "String", Notes: "Subject for the email." },
                                { Name: "Attachment", Type: "String", Notes: "File Path on the JNIOR to reference a file." },
                                { Name: "Message", Type: "String", Notes: "Message for the email." },
                            ]  
                        },
                        {
                            Title: "Email Profile", Source: "communication-emailprofilesend.html", Arguments: [
                                { Name: "Email Profile", Type: "String", Notes: "The name of an email profile preconfigured on the JNIOR that will execute from this action." },
                            ]    
                        },
                        {
                            Title: "MQTT Publish", Source: "communication-mqttpublish.html", Arguments: [
                                { Name: "MQTT Topic", Type: "String", Notes: "Pathing for setting a value for a MQTT topic" },
                                { Name: "Value", Type: "Any", Notes: "Value that the topic will be set to." },
                            ]   
                        },
                        {
                            Title: "SNMP Trap", Source: "communication-snmptrap.html", Arguments: [
                                { Name: "OID", Type: "String", Notes: "OID for the SNMP device." },
                                { Name: "Value", Type: "Any", Notes: "Value that the topic will be set to." },
                                { Name: "SNMP Device", Type: "Any", Notes: "SNMP device from Device Tag." },
                            ]    
                        },
                        {
                            Title: "SNMP Set", Source: "communication-snmpset.html", Arguments: [
                                { Name: "OID", Type: "String", Notes: "OID for the SNMP device." },
                                { Name: "Value", Type: "Any", Notes: "Value that the topic will be set to." },
                                { Name: "Data Type", Type: "Integer or String", Notes: "Data Type of the alue being set to the SNMP Device" },
                                { Name: "SNMP Device", Type: "Dropdown", Notes: "SNMP device from Device Tag." },
                            ]  
                        },
                        { 
                            Title: "OSC Send", Source: "communication-oscsend.html", Arguments: [
                                { Name: "Address", Type: "Text", Notes: "Address for the OSC value." },
                                { Name: "Value", Type: "Any", Notes: "The OSC value that will be sent to the OSC Device." },
                                { Name: "OSC Device", Type: "Dropdown", Notes: "OSC device getting sent the value." },
                            ]  
                        }
                    ]
                }
            ]
        },
        {
            Title: "Value Syntax", Source: "value-syntax.html", Topics: [
                { Title: "Internal IO" },
                { Title: "Temperature Probe IO" },
                { Title: "Environmental Sensor IO" },
                { Title: "Math Functions" },
                { Title: "Trigger References" },
                { Title: "Buffer"},
                { Title: "Parse" },
                { Title: "Validate Days of Week" },
                { Title: "Validate Time of Day" },
                { Title: "Date" },
                { Title: "String Format" },
                { Title: "HexUtils"},
                { Title: "File" },
                { Title: "Read Registry" },
                { Title: "Arrays" },
                { Title: "4-20ma IO" },
                { Title: "10volt IO" },
                { Title: "Control Panel" }
            ]
        },
        {
            Title: "Action Examples", Source: "action-examples.html", Topics:
                [
                    { Title: "Action Examples" }
                ]
        },
        {
            Title: "Logging Examples", Source: "logging-examples.html", Topics:
                [
                    { Title: "Logging Examples" }
                ]
        },
        {
            Title: "Logical Expressions", Source: "logical-expressions.html", Topics:
                [
                    { Title: "Simple Expressions" },
                    { Title: "Complex Expressions" }
                ]
        },
        {
            Title: "Sending Commands to Tasker", Source: "sending-commands-to-tasker.html", Topics:
                [
                    { Title: "ASCII TCP" },
                    { Title: "WebSockets" },
                    { Title: "Rest API" }
                ]
        },
        { Title: "Troubleshooting", Source: "troubleshooting.html" }
    ];


    _this.ActiveTopic = _this.Topics[0];



    // watch for changes to our $location.url() object.
    $scope.$watch(function () {
        return $location.url();
    }, function (url) {
        if (url) {
            var locationSearch = $location.search();
            _this.BlockId = locationSearch.blockId;
            if (_this.BlockId) {
                scrollTo('#' + _this.BlockId);
            }
        }
    });



    _this.setTopic = function (id) {
        var blockId = _this.GetWebSafe(id);
        $location.search('blockId', blockId);
    };



    _this.showBlock = function (blockId) {
        return !_this.BlockId || blockId == _this.BlockId;
    };


    _this.setOrder = function (order) {
        _this.order = order;
    };



    _this.getHtml = function (block) {
        return block.Id + '.html';
    };



    _this.scrollTo = function (block) {
        $location.search('blockId', block.Id);
    };


    _this.Blocks = [
        {
            Id: "value-syntax", Title: "Value Syntax", Category: "Syntax", Since: "3.0",
        },
        {
            Id: "action-examples", Title: "Task Examples", Category: "Examples", Since: "3.0",
        },
        {
            Id: "logging-examples", Title: "Logger Examples", Category: "Examples", Since: "3.0",
        },
        {
            Id: "other-comment", Title: "Comment", Category: "Other Actions", Since: "3.0", Arguments: [
                { Name: "Description", Type: "Text" },
            ]
        },
        {
            Id: "other-commandline", Title: "Command Line", Category: "Other Actions", Since: "3.0", Arguments: [
                { Name: "Command", Type: "Text" },
            ]
        },
        {
            Id: "other-reboot", Title: "Reboot", Category: "Other Actions", Since: "3.0", Arguments: [
            ]
        },
        {
            Id: "other-executetask", Title: "Execute Task", Category: "Other Actions", Since: "3.0", Arguments: [
                { Name: "Task", Type: "Text" },
            ]
        },
        {
            Id: "other-canceltask", Title: "Cancel Task", Category: "Other Actions", Since: "4.1", Arguments: [
                { Name: "Task Name", Type: "Text" },
            ]
        },
        {
            Id: "other-executescript", Title: "Execute Script Task", Category: "Other Actions", Since: "3.3", Arguments: [
                { Name: "Script Box", Type: "Text" },
            ]
        },
        {
            Id: "other-useralert", Title: "User Alert", Category: "Other Actions", Since: "3.5", Arguments: [
                { Name: "User Alert", Type: "Text" },
            ]
        },
        {
            Id: "other-deletefile", Title: "Delete File", Category: "Other Actions", Since: "3.3", Arguments: [
                { Name: "File Name", Type: "Text" },
            ]
        },
        {
            Id: "other-prependfile", Title: "Prepend File", Category: "Other Actions", Since: "3.3", Arguments: [
                { Name: "File Name", Type: "Text" },
                { Name: "Added Text", Type: "Text" },
            ]
        },
        {
            Id: "other-copyfile", Title: "Copy File", Category: "Other Actions", Since: "3.3", Arguments: [
                { Name: "File Name", Type: "Text" },
                { Name: "File Destination", Type: "Text" },
            ]
        },
        {
            Id: "other-movefile", Title: "Move File", Category: "Other Actions", Since: "3.3", Arguments: [
                { Name: "File Name", Type: "Text" },
                { Name: "File Destination", Type: "Text" },
            ]
        },
        {
            Id: "timing-sleep", Title: "Sleep", Category: "Timing Actions", Since: "3.0", Arguments: [
                { Name: "Duration", Type: "Number Block" },
            ]
        },
        {
            Id: "relayinputs-softinputinvert", Title: "Soft Input Invert", Category: "Input Actions", Since: "3.2", Arguments: [
                { Name: "Channel", Type: "Number Block" },
            ]
        },
        {
            Id: "relayinputs-setinputcounter", Title: "Set Input Counter", Category: "Input Actions", Since: "3.2", Arguments: [
                { Name: "Channel", Type: "Number Block" },
            ]
        },
        {
            Id: "relayinputs-resetinputusagemeter", Title: "Reset Input Usage Meter", Category: "Input Actions", Since: "3.2", Arguments: [
                { Name: "Channel", Type: "Number Block" },
            ]
        },
        {
            Id: "relayoutputs-closerelay", Title: "Close Relay", Category: "Output Actions", Since: "3.0", Arguments: [
                { Name: "Channel", Type: "Number Block" },
            ]
        },
        {
            Id: "relayoutputs-openrelay", Title: "Open Relay", Category: "Output Actions", Since: "3.0", Arguments: [
                { Name: "Channel", Type: "Number Block" },
            ]
        },
        {
            Id: "relayoutputs-setrelay", Title: "Set Relay State", Category: "Output Actions", Since: "3.0", Arguments: [
                { Name: "Channel", Type: "Number Block" },
                { Name: "State", Type: "HIGH or LOW" },
            ]
        },
        {
            Id: "relayoutputs-pulserelay", Title: "Pulse Relay", Category: "Output Actions", Since: "3.0", Arguments: [
                { Name: "Channel", Type: "Number Block" },
                { Name: "Duration", Type: "Seconds, can use decimals" }
            ]
        },
        {
            Id: "relayoutputs-setrelays", Title: "Set Relay States", Category: "Output Actions", Since: "3.0", Arguments: [
                { Name: "Channels", Type: "Number Block" },
                { Name: "States", Type: "Number Block" },
            ]
        },
        {
            Id: "relayoutputs-pulserelays", Title: "Pulse Relay States", Category: "Output Actions", Since: "3.0", Arguments: [
                { Name: "Channel", Type: "Number Block" },
                { Name: "States", Type: "Number Block" },
                { Name: "Duration", Type: "Seconds, can use decimals" }
            ]
        },
        {
            Id: "analogoutputs-set10vpercentage", Title: "Set 10v Percentage", Category: "Analog Output Actions", Since: "3.0", Arguments: [
                { Name: "Channel", Type: "Number Block" },
                { Name: "Percentage", Type: "Number Block" },
            ]
        },
        {
            Id: "analogoutputs-set10vvoltage", Title: "Set 10v Voltage", Category: "Analog Output Actions", Since: "3.0", Arguments: [
                { Name: "Channel", Type: "Number Block" },
                { Name: "Voltage", Type: "Number Block, can use decimals" },
            ]
        },
        {
            Id: "analogoutputs-set420mapercentage", Title: "Set 4-20ma Percentage", Category: "Analog Output Actions", Since: "3.0", Arguments: [
                { Name: "Channel", Type: "Number Block" },
                { Name: "Percentage", Type: "Number Block" },
            ]
        },
        {
            Id: "analogoutputs-set420maamps", Title: "Set 4-20ma Amps", Category: "Analog Output Actions", Since: "3.0", Arguments: [
                { Name: "Channel", Type: "Number Block" },
                { Name: "Amps", Type: "Number Block, can use decimals" },
            ]
        },
        {
            Id: "controlstructures-ifblock", Title: "If Block", Category: "Control Structure Actions", Since: "3.0", Arguments: [
                { Name: "If Variable", Type: "Text" },
            ]
        },
        {
            Id: "controlstructures-ifelseblock", Title: "If Else Block", Category: "Control Structure Actions", Since: "3.1", Arguments: [
                { Name: "If Variable", Type: "Text" },
            ]
        },
        {
            Id: "controlstructures-loop", Title: "Loop", Category: "Control Structure Actions", Since: "3.0", Arguments: [
                { Name: "Loop Variable", Type: "Text" },
                { Name: "Start Value of Length", Type: "Number Block" },
                { Name: "End Value of Length", Type: "Number Block" },
            ]
        },
        {
            Id: "controlstructures-whileloop", Title: "While Loop", Category: "Control Structure Actions", Since: "3.1", Arguments: [
                { Name: "Loop Variable", Type: "Text" },
            ]
        },
        {
            Id: "controlstructures-setvariable", Title: "Set Variable", Category: "Control Structure Actions", Since: "3.1", Arguments: [
                { Name: "Variable", Type: "Text" },
                { Name: "Value", Type: "Text" },
            ]
        },
        {
            Id: "controlpanel-setled", Title: "Set LED", Category: "Control Panel Actions", Since: "3.0", Arguments: [
                { Name: "Channel", Type: "Number Block" },
                { Name: "LED State", Type: "Drop-Down option" },
            ]
        },
        {
            Id: "controlpanel-playalarm", Title: "Play Alarm", Category: "Control Panel Actions", Since: "3.0", Arguments: [
                { Name: "Alarm Rate", Type: "Drop-Down option" },
                { Name: "Duration", Type: "Seconds, can use decimals" },
                { Name: "Volume Percentage", Type: "Number Block" },
            ]
        },
        {
            Id: "controlpanel-silencealarm", Title: "Silence Alarm", Category: "Control Panel Actions", Since: "3.0", Arguments: [
            ]
        },
        {
            Id: "lighting-setdimmerchannel", Title: "Set LED Dimmer Channel", Category: "Lighting Actions", Since: "3.0", Arguments: [
                { Name: "Channel", Type: "Number Block" },
                { Name: "Percentage", Type: "Number Block" },
            ]
        },
        {
            Id: "lighting-setdimmerrgb", Title: "Set LED Dimmer RGB", Category: "Lighting Actions", Since: "3.0", Arguments: [
                { Name: "Dimmer being set", Type: "Number Block" },
                { Name: "Red Percentage", Type: "Number Block" },
                { Name: "Green Percentage", Type: "Number Block" },
                { Name: "Blue Percentage", Type: "Number Block" },
            ]
        },
        {
            Id: "lighting-fadedimmerchannel", Title: "Fade LED Dimmer Channel", Category: "Lighting Actions", Since: "3.0", Arguments: [
                { Name: "Channel", Type: "Number Block" },
                { Name: "Percentage", Type: "Number Block" },
                { Name: "Duration", Type: "Seconds, can use decimals" },
            ]
        },
        {
            Id: "lighting-fadedimmerrgb", Title: "Fade LED Dimmer RGB", Category: "Lighting Actions", Since: "3.0", Arguments: [
                { Name: "Dimmer being set", Type: "Number Block" },
                { Name: "Red Percentage", Type: "Number Block" },
                { Name: "Green Percentage", Type: "Number Block" },
                { Name: "Blue Percentage", Type: "Number Block" },
                { Name: "Duration", Type: "Seconds, can use decimals" },
            ]
        },
        {
            Id: "logging-logentry", Title: "Log Entry", Category: "Logging Actions", Since: "3.0", Arguments: [
                { Name: "Text to be Logged", Type: "Text" },
                { Name: "File Path", Type: "Text" },
            ]
        },
        {
            Id: "logging-logprofile", Title: "Log Profile", Category: "Logging Actions", Since: "3.0", Arguments: [
                { Name: "Log Profile being called", Type: "Text" },
            ]
        },
        {
            Id: "network-tcpsend", Title: "Tcp Send", Category: "Network Actions", Since: "3.0", Arguments: [
                { Name: "Device", Type: "Drop-Down Select" },
                { Name: "Info being sent", Type: "Text" },
            ]
        },
        {
            Id: "network-tcpreceive", Title: "Tcp Receive", Category: "Network Actions", Since: "3.3", Arguments: [
                { Name: "Device", Type: "Drop-Down Select" },
                { Name: "Info being sent", Type: "Text" },
            ]
        },
        {
            Id: "network-tcpclose", Title: "Tcp Close", Category: "Network Actions", Since: "3.3", Arguments: [
                { Name: "Device", Type: "Drop-Down Select" },
                { Name: "Info being sent", Type: "Text" },
            ]
        },
        {
            Id: "network-emailsend", Title: "Email Send", Category: "Network Actions", Since: "3.0", Arguments: [
                { Name: "Recipient Email", Type: "Text" },
                { Name: "Email's Subject", Type: "Text" },
                { Name: "Email's Attachment", Type: "Text" },
                { Name: "Email's Message", Type: "Text" },
            ]
        },
        {
            Id: "network-emailprofilesend", Title: "Email Profile Send", Category: "Network Actions", Since: "3.0", Arguments: [
                { Name: "Email Profile", Type: "Text" },
            ]
        },
        {
            Id: "network-snmptrap", Title: "SNMP Trap", Category: "Network Actions", Since: "3.1", Arguments: [
                { Name: "OID", Type: "Number Block" },
                { Name: "Data", Type: "Text" },
                { Name: "Device", Type: "Drop-Down Select" },
            ]
        },
        {
            Id: "network-snmpset", Title: "SNMP Set", Category: "Network Actions", Since: "4.1", Arguments: [
                { Name: "OID", Type: "Number Block" },
                { Name: "Data", Type: "Text" },
                { Name: "Value", Type: "Drop-Down Select" },
                { Name: "Device", Type: "Drop-Down Select" }
            ]
        },
        {
            Id: "network-httprequest", Title: "HTTP Request", Category: "Network Actions", Since: "5.0", Arguments: [
                { Name: "URL Address", Type: "Text" },
            ]
        },
        {
            Id: "network-httppost", Title: "HTTP Post", Category: "Network Actions", Since: "3.8", Arguments: [
                { Name: "URL Address", Type: "Text" },
                { Name: "Data", Type: "Text" }
            ]
        },
    ];

    _this.getCategories = function () {
        return ['Task Actions'];
    };

});



app.directive('toc', function ($compile) {
    return {
        restrict: 'A', // attribute
        scope: {
            topics: '=',
            controller: '='
        },
        link: function ($scope, element, attrs) {
            var template = $scope.topics ? '<li ng-repeat="topic in topics" style="padding-left: 32px;">' +
                '<a href="javascript: void(0);" ng-click="controller.setTopic(topic.Title)"' +
                ' ng-style="{color: topic.Source == \'blank.html\' ? \'rgb(189, 54, 47)\' : \'\'}">{{topic.Title}}</a>' +
                //'<a href="{{topic.Title}}"' +
                //' ng-style="{color: topic.Source == \'blank.html\' ? \'rgb(189, 54, 47)\' : \'\'}">{{topic.Title}}</a>' +
                '<ol toc topics="topic.Topics" controller="controller"></ol>' +
                '</li>' : '';
            element.html(template).show();
            $compile(element.contents())($scope);
        }
    };
});



app.directive('content', function ($compile) {
    return {
        restrict: 'A', // attribute
        scope: {
            topics: '=',
            controller: '=',
            level: '='
        },
        link: function ($scope, element, attrs) {
            var template = $scope.topics ? '<li ng-repeat="topic in topics"' +
                (1 == $scope.level ? ' style="page-break-after: always; page-break-inside: avoid;"' : ' ng-style="{\'page-break-inside\': (undefined == topic.Topics ? \'avoid\' : \'\')}"') + '>' +
                '<h' + $scope.level + ' ng-if="null != topic.Source" id="{{controller.GetWebSafe(topic.Title)}}">' +
                '<span ng-bind="topic.Title"></span>' +
                '<a href="#?blockId={{controller.GetWebSafe(topic.Title)}}"><i class="fa fa-anchor" aria-hidden="true" style="margin-left: 12px; font-size: 14pt;"></i></a>' +
                '</h' + $scope.level + '>' +
                '<div ng-if="null != topic.Source" class="blockdef" style="padding-left: 32px;">' +
                '  <div ng-include="\'/tasker/help/\' + topic.Source"></div>' +
                // '  <div ng-bind-html="controller.trustAsHtml(topic.HTML)" style="padding: 12px 0;"></div>' +
                '  <table ng-show="topic.Arguments !== nothing" class="table table-striped table-condensed">' +
                '  <tr>' +
                '      <th>Element</th>' +
                '      <th>Type</th>' +
                '      <th>Notes</th>' +
                '  </tr>' +
                '  <tr ng-repeat="argument in topic.Arguments">' +
                '      <td ng-bind="argument.Name"></td>' +
                '      <td ng-bind="argument.Type"></td>' +
                '      <td ng-bind-html="controller.trustAsHtml(argument.Notes)"></td>' +
                '  </tr>' +
                '  </table>' +
                '</div>' +
                '<ol ng-if="null != topic.Topics" content topics="topic.Topics" controller="controller" level="' +
                ($scope.level + 1) + '" style="padding-left: 32px;"></ol>' +
                '</li>' : '';
            element.html(template).show();
            $compile(element.contents())($scope);
        }
    };
});



var total = 0;
var fetched = 0;


app.run(function ($rootScope) {
    $rootScope.$on("$includeContentRequested", function (event, templateName) {
        total++;
        console.log('requested ' + templateName + ': ' + total);
    });
});



app.run(function ($rootScope) {
    $rootScope.$on("$includeContentLoaded", function (event, templateName) {
        fetched++;
        console.log('fetched ' + templateName + ': ' + fetched);
        var percentComplete = Math.floor(fetched / total * 100);
        $('#loading-percentage').text(percentComplete);
        if (fetched == total) {
            setTimeout(function () {
                ready();
                $('#loading').hide();
                scrollTo(selectedElementId);
            }, 500);
        }
    });
});