/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker.triggers.triggertypes;

import com.integ.tasker.triggers.Trigger;
import com.integ.tasker.triggers.triggertypes.ContinuousSignalTrigger;
import com.integ.tasker.triggers.triggertypes.ControlPanelMultiSwitchTrigger;
import com.integ.tasker.triggers.triggertypes.ControlPanelSingleSwitchTrigger;
import com.integ.tasker.triggers.triggertypes.DiscreteSignalTrigger;
import com.integ.tasker.triggers.triggertypes.ExpressionEvaluationTrigger;
import com.integ.tasker.triggers.triggertypes.ModbusTagUpdateTrigger;
import com.integ.tasker.triggers.triggertypes.TCPReceiveTrigger;
import com.integ.tasker.triggers.triggertypes.UDPReceiveTrigger;
import java.util.Json;

public class TriggerFactory {
    public static Trigger getTrigger(Json triggerJson) throws Exception {
        System.out.println("triggerJson = " + triggerJson);
        String triggerType = triggerJson.getString("Type");
        System.out.println("triggerType = " + triggerType);
        switch (triggerType) {
            case "DiscreteSignalTrigger": {
                return new DiscreteSignalTrigger(triggerJson);
            }
            case "ContinuousSignalTrigger": {
                return new ContinuousSignalTrigger(triggerJson);
            }
            case "ExpressionEvaluationTrigger": {
                System.out.println("ExpressionEvaluationTrigger");
                return new ExpressionEvaluationTrigger(triggerJson);
            }
            case "ControlPanelSingleSwitchTrigger": {
                return new ControlPanelSingleSwitchTrigger(triggerJson);
            }
            case "ControlPanelMultiSwitchTrigger": {
                return new ControlPanelMultiSwitchTrigger(triggerJson);
            }
            case "TCPReceiveTrigger": {
                return new TCPReceiveTrigger(triggerJson);
            }
            case "UDPReceiveTrigger": {
                return new UDPReceiveTrigger(triggerJson);
            }
            case "ModbusTagUpdateTrigger": {
                return new ModbusTagUpdateTrigger(triggerJson);
            }
        }
        throw new Exception(String.format("Unknown Trigger type: %s", triggerType));
    }
}

