/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.janoslib.http;

import java.io.IOException;

public class HttpURL {
    private static final String HTTP = "http://";
    private static final String HTTPS = "https://";
    private String _protocol = null;
    private String _url = null;
    private String _host = null;
    private int _port = 80;
    private String _file = "";
    private String _query = "";
    private int _endOfHost;
    private int _questionMarkPos;

    public String getProtocol() {
        return this._protocol;
    }

    public String getHost() {
        return this._host;
    }

    public int getPort() {
        return this._port;
    }

    public String getFile() {
        return this._file;
    }

    public String getQuery() {
        return this._query;
    }

    public HttpURL(String url) throws IOException {
        this._url = url;
        if (!this.isHttp()) {
            throw new IOException("Not HTTP or HTTPS");
        }
        System.out.println("   " + this._url);
        this.parseHost();
        this.parseFile();
        this.parseQuery();
        System.out.println("host: " + this._host);
        System.out.println("port: " + this._port);
        System.out.println("file: " + this._file);
        System.out.println("query: " + this._query);
    }

    private boolean isHttp() {
        if (this._url.indexOf("://") > 0) {
            return this._url.toLowerCase().indexOf(HTTP) == 0 || this._url.toLowerCase().indexOf(HTTPS) == 0;
        }
        this._url = HTTP + this._url;
        return true;
    }

    private void parseHost() {
        int protocolSeparator = this._url.indexOf("://");
        this._protocol = this._url.substring(0, protocolSeparator);
        int colonPos = this._url.indexOf(":", protocolSeparator += 3);
        int forwardSlashPos = this._url.indexOf("/", protocolSeparator);
        if (forwardSlashPos < colonPos) {
            forwardSlashPos = this._url.length() - 1;
        }
        if (-1 == forwardSlashPos) {
            forwardSlashPos = this._url.length();
        }
        this._endOfHost = forwardSlashPos;
        String host = this._url.substring(protocolSeparator, this._endOfHost);
        if (colonPos > 0) {
            this._port = Integer.parseInt(this._url.substring(colonPos + 1, forwardSlashPos));
            host = host.substring(0, host.indexOf(":"));
        } else if (this._url.toLowerCase().indexOf(HTTPS) != -1) {
            this._port = 443;
        }
        this._host = host;
    }

    private void parseFile() {
        if (this._url.length() > this._endOfHost) {
            this._questionMarkPos = this._url.indexOf("?");
            this._file = this._questionMarkPos == -1 ? this._url.substring(this._endOfHost + 1) : this._url.substring(this._endOfHost + 1, this._questionMarkPos);
        }
    }

    private void parseQuery() {
        if (this._questionMarkPos > 0) {
            this._query = this._url.substring(this._questionMarkPos);
        }
    }

    public String toString() {
        return this._url;
    }
}

