/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.tasker.ast;

import com.integpg.janoslib.lexer.Token;
import com.integpg.tasker.ast.ASTNode;
import com.integpg.tasker.ast.ASTParser;

public class ASTLogicalNode
implements ASTNode {
    private final Token _operator;
    private final ASTNode _left;
    private final ASTNode _right;

    public ASTLogicalNode(Token operator, ASTNode left, ASTNode right) {
        this._operator = operator;
        this._left = left;
        this._right = right;
    }

    @Override
    public Boolean evaluate() {
        if (ASTParser.isDebug()) {
            System.out.println("ASTLogicalNode: " + this);
        }
        Object left = this._left.evaluate();
        Object right = this._right.evaluate();
        if (ASTParser.isDebug()) {
            System.out.println("opertator: " + this._operator);
        }
        if (ASTParser.isDebug()) {
            System.out.println("left: " + left + " " + left.getClass().getName());
        }
        if (ASTParser.isDebug()) {
            System.out.println("right: " + right + " " + right.getClass().getName());
        }
        switch (this._operator.type) {
            case 11: {
                if (left instanceof Boolean && right instanceof Boolean) {
                    return ((Boolean)left).equals((Boolean)right);
                }
                return ((Number)left).doubleValue() == ((Number)right).doubleValue();
            }
            case 12: {
                if (left instanceof Boolean && right instanceof Boolean) {
                    return !((Boolean)left).equals((Boolean)right);
                }
                return ((Number)left).doubleValue() != ((Number)right).doubleValue();
            }
            case 10: {
                boolean leftBool = false;
                leftBool = left instanceof Boolean ? (Boolean)left : 1.0 == ((Number)left).doubleValue();
                boolean rightBool = false;
                rightBool = right instanceof Boolean ? (Boolean)right : 1.0 == ((Number)right).doubleValue();
                return leftBool && rightBool;
            }
            case 9: {
                boolean leftBool = false;
                leftBool = left instanceof Boolean ? (Boolean)left : 1.0 == ((Number)left).doubleValue();
                boolean rightBool = false;
                rightBool = right instanceof Boolean ? (Boolean)right : 1.0 == ((Number)right).doubleValue();
                return leftBool || rightBool;
            }
            case 60: {
                return ((Number)left).doubleValue() < ((Number)right).doubleValue();
            }
            case 62: {
                return ((Number)left).doubleValue() > ((Number)right).doubleValue();
            }
        }
        return false;
    }

    public String toString() {
        String retString = "(";
        retString = retString + this._left;
        retString = retString + " " + this._operator.content + " ";
        retString = retString + this._right;
        retString = retString + ")";
        return retString;
    }
}

