/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.janoslib.externalio;

import com.integpg.janoslib.externalio.ExternalModule;
import com.integpg.janoslib.logging.AppLog;
import com.integpg.janoslib.utils.ExternalUtils;
import com.integpg.janoslib.utils.HexUtils;
import com.integpg.sensor.SensorPort;
import com.integpg.system.ArrayUtils;
import com.integpg.system.JANOS;
import java.io.IOException;

public class Type7E
extends ExternalModule {
    private static final Type7E NULL_DEVICE = new Type7E(0L);
    private static final int START_ADDR = 32;
    private static final int LENGTH = 32;
    private static final byte[] INIT_DATA = new byte[32];
    private final byte[] _data;
    private double _tempC = Double.NaN;
    private double _tempF = Double.NaN;
    private double _heatIndexC = Double.NaN;
    private double _heatIndexF = Double.NaN;
    private double _dewPointC = Double.NaN;
    private double _dewPointF = Double.NaN;
    private double _humidity = Double.NaN;
    private double _pressureMillibars = Double.NaN;
    private double _pressureInHg = Double.NaN;
    private int _lightLux = -1;
    private boolean _lastReadResult = true;
    public boolean Updated = false;

    public static Type7E getByIndex(int index) throws IOException {
        return Type7E.getByNumber(index + 1);
    }

    public static Type7E getByNumber(int number) throws IOException {
        String deviceAddressString = ExternalUtils.getDeviceAddressFor("7e", number);
        if (!CACHED_DEVICES.containsKey(deviceAddressString)) {
            long address = HexUtils.parseHexAsLong(deviceAddressString);
            CACHED_DEVICES.put(deviceAddressString, new Type7E(address, number));
        }
        return (Type7E)CACHED_DEVICES.get(deviceAddressString);
    }

    Type7E(long address) {
        super(address, -1, "Type7E");
        AppLog.info("new Type7E");
        this._data = new byte[30];
    }

    Type7E(long address, int index) {
        super(address, index, "Type7E");
        AppLog.info("new Type7E");
        this._data = new byte[30];
    }

    @Override
    public boolean hasChanged() {
        return this.Updated;
    }

    @Override
    public long getMinReadInterval() {
        return 1000L;
    }

    public boolean getLastReadResult() {
        return this._lastReadResult;
    }

    public double getTempC() {
        return this._tempC;
    }

    public double getTempF() {
        return this._tempF;
    }

    public double getHeatIndexF() {
        return this._heatIndexF;
    }

    public double getHumidity() {
        return this._humidity;
    }

    public double getPressureInMb() {
        return this._pressureMillibars;
    }

    public double getPressureInHg() {
        return this._pressureInHg;
    }

    public double getLightLux() {
        return this._lightLux;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void read() throws IOException {
        block32: {
            long now;
            int attempt = 0;
            if (attempt >= 3) break block32;
            this.LastReadTime = now = System.currentTimeMillis();
            byte[] data = new byte[35];
            int id = -1;
            boolean successfulRead = true;
            SensorPort sensorPort = SENSOR_PORT;
            synchronized (sensorPort) {
                data[0] = -91;
                data[1] = 32;
                data[2] = 0;
                ArrayUtils.arraycopy((Object)INIT_DATA, (int)0, (Object)data, (int)3, (int)32);
                long start = JANOS.uptimeMillis();
                try {
                    SENSOR_PORT.open();
                    SENSOR_PORT.select(this.Address);
                    SENSOR_PORT.data(data, 0, data.length);
                }
                catch (Exception ex) {
                    successfulRead = false;
                    this._lastReadResult = false;
                    AppLog.error(ex);
                }
                finally {
                    try {
                        SENSOR_PORT.close();
                    }
                    catch (Exception ex) {}
                }
                if (successfulRead) {
                    long elapsed = JANOS.uptimeMillis() - start;
                    System.out.println("elapsed = " + elapsed);
                    this.LastReadTime = System.currentTimeMillis();
                    id = data[3] & 0xFF;
                    if (165 == (data[0] & 0xFF)) {
                        this.Updated = !ArrayUtils.arrayComp((Object)data, (int)5, (Object)this._data, (int)0, (int)30);
                    } else {
                        successfulRead = false;
                        this.Updated = false;
                    }
                    if (ArrayUtils.arrayComp((Object)data, (int)2, (Object)INIT_DATA, (int)0, (int)32)) {
                        successfulRead = false;
                        this.Updated = false;
                    }
                }
            }
            if (successfulRead && this.Updated) {
                ArrayUtils.arraycopy((Object)data, (int)5, (Object)this._data, (int)0, (int)30);
                double tempC = (short)this.getValue(0, 2);
                if (-2.147483648E9 != tempC) {
                    this._tempC = tempC / 16.0;
                    this._tempF = this._tempC * 9.0 / 5.0 + 32.0;
                }
                if (0.0 == this._tempC) {
                    AppLog.warn("bad read: " + HexUtils.bytesToHex(data));
                    throw new RuntimeException("\nbad read: " + HexUtils.bytesToHex(data));
                }
                if (101 == id || 104 == id) {
                    double humIndexC;
                    double dewPointC;
                    double humidity = this.getValue(2, 2);
                    if (-2.147483648E9 != humidity) {
                        this._humidity = humidity / 16.0;
                    }
                    if (-2.147483648E9 != (dewPointC = (double)((short)this.getValue(4, 2)))) {
                        this._dewPointC = dewPointC / 16.0;
                        this._dewPointF = this._dewPointC * 9.0 / 5.0 + 32.0;
                    }
                    if (-2.147483648E9 != (humIndexC = (double)this.getValue(6, 2))) {
                        humIndexC /= 16.0;
                    }
                    double heatIndexC = this.getValue(8, 2);
                    if (-2.147483648E9 != this._heatIndexC) {
                        this._heatIndexC = heatIndexC / 16.0;
                        this._heatIndexF = this._heatIndexC * 9.0 / 5.0 + 32.0;
                    }
                }
                if (102 == id || 104 == id) {
                    double pressureInHg;
                    double pressureMillibars = this.getValue(10, 3);
                    if (-2.147483648E9 != pressureMillibars) {
                        this._pressureMillibars = pressureMillibars / 2048.0;
                    }
                    if (-2.147483648E9 != (pressureInHg = (double)this.getValue(13, 3))) {
                        this._pressureInHg = pressureInHg / 2048.0;
                    }
                }
                if (103 == id || 104 == id) {
                    this._lightLux = this.getValue(16, 3);
                }
            }
            if (0 < attempt) {
                AppLog.warn("Type7E retry successful");
            }
        }
    }

    @Override
    public void commit() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void printValues() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private int getValue(int idx, int len) {
        int value = 0;
        boolean invalid = true;
        while (len-- > 0) {
            value <<= 8;
            int b = this._data[idx + len] & 0xFF;
            invalid &= b == 255;
            value += b;
        }
        if (invalid) {
            value = Integer.MIN_VALUE;
        }
        return value;
    }

    public static Object get(int channel, String fieldName) {
        try {
            int index = channel - 1;
            Type7E device = Type7E.getByIndex(index);
            if (null != device) {
                device.read();
                return device.get(fieldName);
            }
            throw new RuntimeException("Environmental Sensor not present for index " + index);
        }
        catch (IOException ex) {
            throw new RuntimeException("Error getting value for Type7E." + fieldName, ex);
        }
    }

    @Override
    public Object get(String fieldName) {
        if (!this._lastReadResult) {
            return Double.NaN;
        }
        if (0 == this.TypeIndex) {
            throw new RuntimeException("Module must have an index");
        }
        if ("c".equalsIgnoreCase(fieldName) || "celsius".equalsIgnoreCase(fieldName) || "tempc".equalsIgnoreCase(fieldName)) {
            return this.getTempC();
        }
        if ("f".equalsIgnoreCase(fieldName) || "fahrenheit".equalsIgnoreCase(fieldName) || "tempf".equalsIgnoreCase(fieldName)) {
            return this.getTempF();
        }
        if ("h".equalsIgnoreCase(fieldName) || "hum".equalsIgnoreCase(fieldName) || "humidity".equalsIgnoreCase(fieldName)) {
            return this.getHumidity();
        }
        if ("heatindexf".equalsIgnoreCase(fieldName)) {
            return this.getHeatIndexF();
        }
        if ("pressuremb".equalsIgnoreCase(fieldName) || "mb".equalsIgnoreCase(fieldName)) {
            return this.getPressureInMb();
        }
        if ("pressurehg".equalsIgnoreCase(fieldName) || "hg".equalsIgnoreCase(fieldName)) {
            return this.getPressureInHg();
        }
        if ("lux".equalsIgnoreCase(fieldName)) {
            return this.getLightLux();
        }
        throw new RuntimeException("Invalid Field Name: " + fieldName);
    }

    static {
        for (int n = 0; n < 32; ++n) {
            Type7E.INIT_DATA[n] = -1;
        }
    }
}

