/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker.tasks.actions.network;

import com.integ.tasker.tasks.Task;
import com.integ.tasker.tasks.TaskRuntime;
import com.integ.tasker.tasks.actions.Action;
import com.integpg.janoslib.utils.StringUtils;
import com.integpg.system.MailComposer;
import com.integpg.tasker.TextReplacer;
import java.util.Json;

public class EmailSendMethod
extends Action {
    private final String _toRecipient;
    private final String _subject;
    private final String _attachment;
    private final String _body;

    public EmailSendMethod(Task parentTask, Json json) throws Throwable {
        super(parentTask, json);
        try {
            this._toRecipient = StringUtils.trim(this._paramsJson.getString("ToRecipient"), ' ');
            this._subject = StringUtils.trim(this._paramsJson.getString("Subject"), ' ');
            String attachmentString = null;
            if (this._paramsJson.containsKey("Attachment") && null != (attachmentString = this._paramsJson.getString("Attachment")) && 0 < attachmentString.length()) {
                attachmentString = StringUtils.trim(attachmentString, ' ');
            }
            this._attachment = attachmentString;
            this._body = StringUtils.trim(this._paramsJson.getString("Body"), ' ');
        }
        catch (Exception ex) {
            throw new RuntimeException("Error loading Email Send class").initCause(ex);
        }
    }

    @Override
    public void execute(TaskRuntime taskRuntime) throws Throwable {
        try {
            System.out.println("EmailSend command");
            String subject = this._subject;
            System.out.println("subject: " + subject);
            subject = TextReplacer.replace(subject, taskRuntime.Scope);
            System.out.println("subject: " + subject);
            String message = this._body;
            System.out.println("message: " + message);
            message = TextReplacer.replace(message, taskRuntime.Scope);
            System.out.println("message: " + message);
            byte[] messageBytes = StringUtils.getEscapedBytes(message);
            MailComposer mailComposer = new MailComposer();
            mailComposer.setToAddress(this._toRecipient);
            mailComposer.setSubject(subject);
            mailComposer.setAttachment(this._attachment);
            String messageHtml = new String(messageBytes);
            mailComposer.setMessageHTML(messageHtml);
            mailComposer.send();
        }
        catch (Exception ex) {
            throw new Exception("Error executing Email Send").initCause(ex);
        }
    }
}

