/*
 * Decompiled with CFR 0.152.
 */
package com.integ.scripting.objects;

import com.integ.scripting.ParseEngine;
import com.integ.scripting.exceptions.ScriptParserException;
import com.integ.scripting.exceptions.UnexpectedTokenException;
import com.integ.scripting.nodes.AbstractNode;
import com.integ.scripting.objects.AbstractObjectCall;
import com.integ.tasker.tasks.Scope;
import com.integpg.janoslib.externalio.TypeFE;
import com.integpg.janoslib.io.AppLog;
import java.io.IOException;
import java.text.DecimalFormat;

public class FourTwentyInputObject
extends AbstractObjectCall {
    private static final DecimalFormat FORMAT = new DecimalFormat("0.00");
    private static final int CHANNELS_PER_MODULE = 4;
    private AbstractNode _channelNode;

    @Override
    public AbstractNode parse(ParseEngine parser) throws ScriptParserException {
        try {
            if (!parser.nextToken().checkType(91)) {
                throw new UnexpectedTokenException("[", parser.currentToken());
            }
            parser.nextToken();
            if (!parser.currentToken().checkType(3) && !parser.currentToken().checkType(0)) {
                throw new UnexpectedTokenException("NUMBER | IDENTIFIER", parser.currentToken());
            }
            this._channelNode = parser.getObject();
            if (!parser.nextToken().checkType(93)) {
                throw new UnexpectedTokenException("]", parser.currentToken());
            }
            if (!parser.nextToken().checkType(46)) {
                throw new UnexpectedTokenException(".", parser.currentToken());
            }
            if (!parser.nextToken().checkType(0)) {
                throw new UnexpectedTokenException("FIELD NAME", parser.currentToken());
            }
            this._fieldOrMethodName = parser.currentToken().content;
        }
        catch (Exception ex) {
            throw new ScriptParserException("unable to process four twenty input object", ex);
        }
        return this;
    }

    @Override
    public Object execute(Scope scope) {
        int channel = (Integer)this._channelNode.execute(scope);
        int moduleIndex = (channel - 1) / 4;
        TypeFE typeFe = TypeFE.getByIndex(moduleIndex);
        if (null != typeFe) {
            try {
                typeFe.read();
                int localChannel = (channel - 1) % 4 + 1;
                Object value = typeFe.get(String.format("%sin_%d", this._fieldOrMethodName, localChannel));
                if (value instanceof Double) {
                    return FORMAT.format(value);
                }
                return value;
            }
            catch (IOException ex) {
                AppLog.error(String.format("error getting 4-20ma %s for input channel %d", this._fieldOrMethodName, channel), ex);
            }
        }
        return Double.NaN;
    }
}

