/*
 * Decompiled with CFR 0.152.
 */
package com.integ.scripting.nodes;

import com.integ.scripting.nodes.AbstractNode;
import com.integ.tasker.lexer.Token;
import com.integ.tasker.tasks.Scope;

public class BinaryNode
extends AbstractNode {
    public Token _operator;
    public AbstractNode _left;
    public AbstractNode _right;

    public BinaryNode(Token operator, AbstractNode left, AbstractNode right) {
        this._operator = operator;
        this._left = left;
        this._right = right;
    }

    public String toString() {
        String left = null != this._left ? this._left.toString() : "null";
        String operator = null != this._operator ? this._operator.content : "null";
        String right = null != this._right ? this._right.toString() : "null";
        return String.format("(%s %s %s)", left, operator, right);
    }

    @Override
    public Object execute(Scope scope) {
        Object left = this._left.execute(scope);
        Number leftNumber = (Number)left;
        Object right = this._right.execute(scope);
        Number rightNumber = (Number)right;
        switch (this._operator.type) {
            case 43: {
                if (left instanceof Integer && right instanceof Integer) {
                    return leftNumber.intValue() + rightNumber.intValue();
                }
                if (left instanceof Double && right instanceof Integer) {
                    return leftNumber.doubleValue() + (double)rightNumber.intValue();
                }
                if (left instanceof Integer && right instanceof Double) {
                    return (double)leftNumber.intValue() + rightNumber.doubleValue();
                }
                return leftNumber.doubleValue() + rightNumber.doubleValue();
            }
            case 45: {
                if (leftNumber instanceof Integer && right instanceof Integer) {
                    return leftNumber.intValue() - rightNumber.intValue();
                }
                return leftNumber.doubleValue() - rightNumber.doubleValue();
            }
            case 42: {
                if (left instanceof Integer && right instanceof Integer) {
                    return leftNumber.intValue() * rightNumber.intValue();
                }
                if (left instanceof Double && right instanceof Integer) {
                    return leftNumber.doubleValue() * (double)rightNumber.intValue();
                }
                if (left instanceof Integer && right instanceof Double) {
                    return (double)leftNumber.intValue() * rightNumber.doubleValue();
                }
                return leftNumber.doubleValue() * rightNumber.doubleValue();
            }
            case 47: {
                return leftNumber.doubleValue() / rightNumber.doubleValue();
            }
        }
        return Double.NaN;
    }
}

