/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker.tasks.actions.other;

import com.integ.janoslib.messagepump.MessagePumpEngine;
import com.integ.tasker.tasks.RunningTaskCollection;
import com.integ.tasker.tasks.Task;
import com.integ.tasker.tasks.TaskConfiguration;
import com.integ.tasker.tasks.TaskRuntime;
import com.integ.tasker.tasks.actions.Action;
import com.integ.tasker.web.messages.ErrorMessage;
import com.integpg.janoslib.logger.AppLog;
import java.io.IOException;
import java.util.Json;

public class CancelTaskMethod
extends Action {
    private final String _taskName;

    public CancelTaskMethod(Task parentTask, Json json) {
        super(parentTask, json);
        this._taskName = this._paramsJson.getString("TaskName");
    }

    @Override
    public void execute(TaskRuntime taskRuntime) throws Throwable {
        try {
            if (this._taskName.equals(this._parentTask.Name)) {
                taskRuntime.Cancelled = true;
                Thread.currentThread().interrupt();
            }
            TaskConfiguration.LOG.info("Request to Cancel " + this._taskName);
            RunningTaskCollection.killTask(this._taskName);
        }
        catch (Throwable ex) {
            AppLog.error(ex);
            ErrorMessage message = new ErrorMessage(ex);
            MessagePumpEngine.postMessage(message.build());
            throw new IOException("Error cancelling task: " + this._taskName).initCause(ex);
        }
    }
}

