/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker.tasks.actions.logger;

import com.integ.sorting.FileDateComparer;
import com.integ.sorting.QuickSort;
import com.integ.tasker.TextReplacer;
import com.integ.tasker.loggers.LogProfile;
import com.integ.tasker.loggers.LogProfilesCollection;
import com.integ.tasker.tasks.Task;
import com.integ.tasker.tasks.TaskConfiguration;
import com.integ.tasker.tasks.TaskRuntime;
import com.integ.tasker.tasks.actions.Action;
import com.integ.tasker.workspaces.WorkspaceFile;
import com.integpg.janoslib.io.AppLog;
import com.integpg.janoslib.logger.FileLog;
import com.integpg.janoslib.logger.LogOptions;
import com.integpg.janoslib.logger.LogTypes;
import com.integpg.janoslib.logger.Logger;
import com.integpg.janoslib.system.Application;
import com.integpg.janoslib.text.QuickDateFormat;
import com.integpg.janoslib.utils.FileUtils;
import com.integpg.janoslib.utils.StringUtils;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Json;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LogProfileMethod
extends Action {
    private static final Logger FILE_RETENTION_LOG = FileLog.getLog(new LogOptions(Application.getAppName() + "_fileretention.log").setLogType(LogTypes.HalfBak));
    private static final QuickDateFormat QUICK_DATE_FORMAT = new QuickDateFormat();
    private final String _logProfileName = this._paramsJson.getString("ProfileName");
    private LogProfile _logProfile;
    private File _parentDirectory;
    private String _compiledName = "";
    private boolean _nullEntryCreated = false;
    private boolean _debug_ = false;

    public LogProfileMethod(Task parentTask, Json json) {
        super(parentTask, json);
    }

    @Override
    public void execute(TaskRuntime taskRuntime) throws Throwable {
        long start = System.currentTimeMillis();
        try {
            this._debug_ = taskRuntime.Scope.isDebug();
            if (this._debug_) {
                System.out.println("      Log to " + this._logProfileName);
            }
            TaskConfiguration taskConfiguration = this._parentTask.getTaskConfiguration();
            WorkspaceFile workspaceConfigurationFile = taskConfiguration.getWorkspaceConfigurationFile();
            LogProfilesCollection logProfileCollection = workspaceConfigurationFile.getLoggerProfileCollection();
            if (this._debug_) {
                System.out.println("      logProfileCollection = " + logProfileCollection);
            }
            this._logProfile = logProfileCollection.getByName(this._logProfileName);
            if (this._debug_) {
                System.out.println("      logProfile: " + this._logProfile);
            }
            if (null != this._logProfile) {
                this.logEntry(taskRuntime);
            }
        }
        catch (Exception ex) {
            throw new Exception("Error executing Log Profile: " + this._logProfileName).initCause(ex);
        }
        long elapsed = System.currentTimeMillis() - start;
        System.out.println(String.format("      %s took %lld", this.getClass().getName(), elapsed));
    }

    private void nullEntry(TaskRuntime taskRuntime) {
        long start = System.currentTimeMillis();
        String filename = this.evaluateFilename(taskRuntime);
        try {
            if (this._debug_) {
                System.out.println("filename: " + filename);
            }
            File file = new File(filename);
            this._parentDirectory = new File(file.getParent());
            if (this._debug_) {
                System.out.println("parentDirectory.getPath(): " + this._parentDirectory.getPath());
            }
            if (this._debug_) {
                System.out.println("parentDirectory.exists(): " + this._parentDirectory.exists());
            }
            if (!this._parentDirectory.exists()) {
                if (this._debug_) {
                    System.out.println("Create directory for " + this._parentDirectory.getPath());
                }
                this._parentDirectory.mkdir();
            }
            String nullEntry = this._logProfile.Schema;
            while (-1 != nullEntry.indexOf("{{")) {
                nullEntry = nullEntry.substring(0, nullEntry.indexOf("{{")) + "null" + nullEntry.substring(nullEntry.indexOf("}}") + 2);
            }
            if (this._debug_) {
                System.out.println("nullEntry: " + nullEntry);
            }
            String line = this._logProfile.DateFormat.format(System.currentTimeMillis()) + ", " + nullEntry + "\r\n";
            FileUtils.appendAllBytes(filename, line.getBytes());
            if (!this._compiledName.equals(filename)) {
                this.newFileCreated();
                this._compiledName = filename;
            }
        }
        catch (Exception ex) {
            AppLog.error("error logging entry to " + filename, ex);
        }
        long elapsed = System.currentTimeMillis() - start;
        if (this._debug_) {
            System.out.println("elapsed: " + elapsed);
        }
    }

    private void logHeader(String filename, TaskRuntime taskRuntime) throws IOException {
        if (null != this._logProfile.Header && 0 != this._logProfile.Header.length()) {
            String schemaResult = TextReplacer.replace(this._logProfile.Header, taskRuntime.Scope);
            if (this._debug_) {
                System.out.println("schemaResult: " + schemaResult);
            }
            String line = schemaResult + "\r\n";
            byte[] bytes = StringUtils.getEscapedBytes(line);
            FileUtils.appendAllBytes(filename, bytes);
        }
    }

    private void logEntry(TaskRuntime taskRuntime) {
        String filename = this.evaluateFilename(taskRuntime);
        try {
            if (this._debug_) {
                System.out.println("filename: " + filename);
            }
            File file = new File(filename);
            if (this._debug_) {
                System.out.println(String.format("%s exists? %s", filename, String.valueOf(file.exists())));
            }
            if (!file.exists() && null != this._logProfile.Header) {
                this.logHeader(filename, taskRuntime);
            }
            this._parentDirectory = new File(file.getParent());
            if (this._debug_) {
                System.out.println("parentDirectory.getPath(): " + this._parentDirectory.getPath());
            }
            if (this._debug_) {
                System.out.println("parentDirectory.exists(): " + this._parentDirectory.exists());
            }
            if (!this._parentDirectory.exists()) {
                if (this._debug_) {
                    System.out.println("Create directory for " + this._parentDirectory.getPath());
                }
                this._parentDirectory.mkdir();
            }
            if (!this._nullEntryCreated) {
                if (this._logProfile.LogNullOnBoot) {
                    this.nullEntry(taskRuntime);
                }
                this._nullEntryCreated = true;
            }
            String line = this._logProfile.DateFormat.format(System.currentTimeMillis()) + ", ";
            if (null != this._logProfile.Schema && !"".equals(this._logProfile.Schema)) {
                if (this._debug_) {
                    System.out.println("_logProfile.Schema: " + this._logProfile.Schema);
                }
                String schemaResult = TextReplacer.replace(this._logProfile.Schema, taskRuntime.Scope, this._logProfile.ValueToLogOnError);
                if (this._debug_) {
                    System.out.println("schemaResult: " + schemaResult);
                }
                line = line + schemaResult + "\r\n";
            }
            if (this._debug_) {
                System.out.println("line: " + line);
            }
            FileUtils.appendAllBytes(filename, line.getBytes());
            if (!this._compiledName.equals(filename)) {
                this.newFileCreated();
                this._compiledName = filename;
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("error logging entry to " + filename, ex);
        }
    }

    private String evaluateFilename(TaskRuntime taskRuntime) {
        String filename = this._logProfile.FileName;
        filename = TextReplacer.replace(filename, taskRuntime.Scope, "");
        if (this._debug_) {
            System.out.println("filename: " + filename);
        }
        return filename;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void newFileCreated() {
        LogProfileMethod logProfileMethod = this;
        synchronized (logProfileMethod) {
            try {
                FILE_RETENTION_LOG.info("LogProfileMethod perform file retention logic");
                FILE_RETENTION_LOG.info("_fileRetentionCount: " + this._logProfile.FilesToRetain);
                FILE_RETENTION_LOG.info("_filenameFormat: " + this._logProfile.FileName);
                String filenameFormat = this._logProfile.FileName;
                FILE_RETENTION_LOG.info("filenameFormat: " + filenameFormat);
                while (-1 != filenameFormat.indexOf("{{")) {
                    int endOfReplacer = filenameFormat.indexOf("}}");
                    filenameFormat = -1 != filenameFormat.indexOf("{{date(") ? filenameFormat.substring(0, filenameFormat.indexOf("{{")) + this.getDateReplacer(filenameFormat, endOfReplacer) + filenameFormat.substring(endOfReplacer + 2) : filenameFormat.substring(0, filenameFormat.indexOf("{{")) + ".*" + filenameFormat.substring(endOfReplacer + 2);
                    FILE_RETENTION_LOG.info("filenameFormat: " + filenameFormat);
                }
                FILE_RETENTION_LOG.info("gather matching files for " + filenameFormat);
                final Pattern pattern = Pattern.compile(filenameFormat);
                String[] fileNames = this._parentDirectory.list(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        try {
                            String fullFilename = dir + "/" + name;
                            Matcher matcher = pattern.matcher(fullFilename);
                            boolean accept = matcher.find();
                            return accept;
                        }
                        catch (Exception ex) {
                            FILE_RETENTION_LOG.error(ex);
                            return false;
                        }
                    }
                });
                FILE_RETENTION_LOG.info(fileNames.length + " files found");
                ArrayList<File> filesList = new ArrayList<File>();
                for (String filename : fileNames) {
                    filesList.add(new File(this._parentDirectory + "/" + filename));
                }
                FILE_RETENTION_LOG.info("sorting files by date.  newest to oldest");
                File[] filesArray = (File[])filesList.toArray();
                QuickSort<File> quickSort = new QuickSort<File>();
                quickSort.sort(filesArray, new FileDateComparer(1));
                for (int i = this._logProfile.FilesToRetain; i < filesArray.length; ++i) {
                    File fileToDelete = filesArray[i];
                    if (this._debug_) {
                        System.out.println("delete " + fileToDelete.getPath() + " " + QUICK_DATE_FORMAT.format(fileToDelete.lastModified()) + "?");
                    }
                    if (!fileToDelete.delete()) continue;
                    FILE_RETENTION_LOG.info(" removed " + fileToDelete.getPath());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private String getDateReplacer(String filenameFormat, int endOfReplacer) {
        String replacer = "";
        String innerDateString = filenameFormat.substring(filenameFormat.indexOf("{{date(") + 8, endOfReplacer - 2);
        for (int i = 0; i < innerDateString.length(); i += 2) {
            if (i == innerDateString.indexOf("MM")) {
                replacer = replacer + "0[0-9]|1[0-2]";
                continue;
            }
            if (i == innerDateString.indexOf("DD") || i == innerDateString.indexOf("dd")) {
                replacer = replacer + "[0-3][0-9]";
                continue;
            }
            if (i == innerDateString.indexOf("YYYY") || i == innerDateString.indexOf("yyyy")) {
                replacer = replacer + "20[0-2][0-9]";
                continue;
            }
            if (i == innerDateString.indexOf("YY") || i == innerDateString.indexOf("yy")) {
                replacer = replacer + "[0-2][0-9]";
                continue;
            }
            if (i == innerDateString.indexOf("HH")) {
                replacer = replacer + "([0-1][0-9]|2[0-3])";
                continue;
            }
            if (i == innerDateString.indexOf("hh")) {
                replacer = replacer + "((0[1-9])|(1[0-2]))";
                continue;
            }
            if (i == innerDateString.indexOf("mm")) {
                replacer = replacer + "[0-5][0-9]";
                continue;
            }
            if (i == innerDateString.indexOf("ss")) {
                replacer = replacer + "[0-5][0-9]";
                continue;
            }
            if (i == innerDateString.indexOf("f") || i == innerDateString.indexOf("S")) {
                replacer = replacer + "[0-9]";
                continue;
            }
            if (i == innerDateString.indexOf("f") || i == innerDateString.indexOf("S")) {
                replacer = replacer + "[0-9]";
                continue;
            }
            if (i == innerDateString.indexOf("zzz")) {
                replacer = replacer + "[a-z]|[A-Z]";
                continue;
            }
            if (i == innerDateString.indexOf("aa")) {
                replacer = replacer + "am|pm";
                continue;
            }
            char c = innerDateString.charAt(i);
            replacer = replacer + c;
            --i;
        }
        return replacer;
    }
}

