/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker;

import com.integ.tasker.FileModifiedEvent;
import com.integ.tasker.FileModifiedListener;
import com.integpg.janoslib.io.AppLog;
import com.integpg.janoslib.text.QuickDateFormat;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class FileSystemMonitor
implements Runnable {
    private static final FileSystemMonitor INSTANCE = new FileSystemMonitor();
    private static final Hashtable<File, Long> LAST_MODIFIED_TIME_BY_FILE = new Hashtable();
    private static final Hashtable<File, FileModifiedListener> LISTENER_BY_FILE = new Hashtable();
    private static Thread Thread = null;

    public static void addPath(File file, FileModifiedListener fileModifiedListener) {
        AppLog.info("Added " + file.getAbsolutePath() + " to the FileSystemMonitor::" + fileModifiedListener);
        LAST_MODIFIED_TIME_BY_FILE.put(file, file.lastModified());
        LISTENER_BY_FILE.put(file, fileModifiedListener);
    }

    public static void removePath(File file) {
        LISTENER_BY_FILE.remove(file);
        LAST_MODIFIED_TIME_BY_FILE.remove(file);
    }

    public static void start() {
        if (null == Thread) {
            Thread = new Thread(INSTANCE);
            Thread.setName(INSTANCE.getClass().getName());
            Thread.setDaemon(true);
            Thread.start();
        }
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    ArrayList<File> files = this.getFiles();
                    for (File file : files) {
                        long lastModifiedTime = LAST_MODIFIED_TIME_BY_FILE.get(file);
                        if (file.lastModified() == lastModifiedTime) continue;
                        AppLog.info(file.getPath() + " has been modified at " + QuickDateFormat.getDefault().format(file.lastModified()));
                        this.processPath(file);
                    }
                    java.lang.Thread.sleep(10000L);
                }
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
                continue;
            }
            catch (Exception ex) {
                AppLog.error(ex);
                continue;
            }
            break;
        }
    }

    private void processPath(File file) {
        FileModifiedListener fileModifiedListener = LISTENER_BY_FILE.get(file);
        if (null != fileModifiedListener) {
            if (file.isFile()) {
                fileModifiedListener.fileModified(new FileModifiedEvent(this, file));
            } else if (file.isDirectory()) {
                fileModifiedListener.directoryModified(new FileModifiedEvent(this, file));
            } else if (!file.exists()) {
                fileModifiedListener.fileRemoved(new FileModifiedEvent(this, file));
            }
        }
        if (file.exists()) {
            LAST_MODIFIED_TIME_BY_FILE.put(file, file.lastModified());
        } else {
            LAST_MODIFIED_TIME_BY_FILE.remove(file);
        }
    }

    public static void forceCheck() {
        Thread.interrupt();
    }

    private ArrayList<File> getFiles() {
        ArrayList<File> files = new ArrayList<File>();
        Enumeration<File> filesEnum = LAST_MODIFIED_TIME_BY_FILE.keys();
        while (filesEnum.hasMoreElements()) {
            files.add(filesEnum.nextElement());
        }
        return files;
    }
}

