/*
 * Decompiled with CFR 0.152.
 */
package com.integ.scripting.objects;

import com.integ.scripting.ExpressionEngine;
import com.integ.scripting.exceptions.ScriptParserException;
import com.integ.scripting.exceptions.UnexpectedTokenException;
import com.integ.scripting.nodes.AbstractNode;
import com.integ.scripting.nodes.ValueNode;
import com.integ.scripting.objects.AbstractObjectCall;
import com.integ.tasker.TaskerMain;
import com.integ.tasker.tasks.Scope;
import com.integpg.janoslib.externalio.controlpanel.ControlPanel;
import com.integpg.janoslib.io.AppLog;

public class ControlPanelLedObject
extends AbstractObjectCall {
    private int _channel;

    @Override
    public AbstractNode parse(ExpressionEngine parser) throws ScriptParserException {
        try {
            if (!parser.nextToken().checkType(91)) {
                throw new UnexpectedTokenException("[", parser.currentToken());
            }
            if (!parser.nextToken().checkType(3)) {
                throw new UnexpectedTokenException("NUMBER", parser.currentToken());
            }
            ValueNode valueNode = (ValueNode)parser.getObject();
            this._channel = (Integer)valueNode.Value;
            if (!parser.nextToken().checkType(93)) {
                throw new UnexpectedTokenException("[]", parser.currentToken());
            }
            if (parser.peekToken().checkType(46)) {
                parser.nextToken();
                if (!parser.nextToken().checkType(0)) {
                    throw new UnexpectedTokenException("FIELD NAME", parser.currentToken());
                }
                this._fieldOrMethodName = parser.currentToken().content;
            }
        }
        catch (Exception ex) {
            throw new ScriptParserException("unable to process digital input");
        }
        return this;
    }

    @Override
    public Object execute(Scope scope) {
        boolean _debug_ = scope.isDebug();
        ControlPanel controlPanel = TaskerMain.getControlPanel();
        if (0 == controlPanel.getPanelCount()) {
            AppLog.info("no control panels detected.  reenumerating now");
            controlPanel = TaskerMain.getControlPanel().enumeratePanels();
        }
        int leds = controlPanel.getLeds();
        if (_debug_) {
            System.out.println("leds = " + leds);
        }
        int ledState = leds >> this._channel - 1 & 1;
        if (_debug_) {
            System.out.println("ledState = " + ledState);
        }
        return ledState;
    }
}

