/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker.tasks.actions.network;

import com.integ.tasker.tasks.Task;
import com.integ.tasker.tasks.TaskRuntime;
import com.integ.tasker.tasks.actions.Action;
import com.integpg.janoslib.utils.StringUtils;
import com.integpg.system.JANOS;
import com.integpg.system.MailComposer;
import com.integpg.tasker.TextReplacer;
import java.util.Json;

public class EmailProfileSendMethod
extends Action {
    private final String _emailProfileName;

    public EmailProfileSendMethod(Task parentTask, Json json) throws Throwable {
        super(parentTask, json);
        try {
            String emailProfileName = this._paramsJson.getString("ProfileName");
            this._emailProfileName = emailProfileName = StringUtils.trim(emailProfileName, '\"');
        }
        catch (Exception ex) {
            throw new RuntimeException("Error loading Email Profile Send class").initCause(ex);
        }
    }

    @Override
    public void execute(TaskRuntime taskRuntime) throws Throwable {
        try {
            System.out.println("EmailProfile command: " + this._emailProfileName);
            String[] toAddresses = JANOS.getRegistryKey((String)("Email/" + this._emailProfileName + "/ToAddress"));
            String[] toCcAddresses = JANOS.getRegistryKey((String)("Email/" + this._emailProfileName + "/CcAddress"));
            String[] toBccAddresses = JANOS.getRegistryKey((String)("Email/" + this._emailProfileName + "/BccAddress"));
            String subject = JANOS.getRegistryString((String)("Email/" + this._emailProfileName + "/Subject"), (String)"");
            System.out.println("subject: " + subject);
            subject = TextReplacer.replace(subject, taskRuntime.Scope);
            System.out.println("subject: " + subject);
            String message = JANOS.getRegistryString((String)("Email/" + this._emailProfileName + "/Message"), (String)"");
            System.out.println("message: " + message);
            message = TextReplacer.replace(message, taskRuntime.Scope);
            System.out.println("message: " + message);
            MailComposer mailComposer = new MailComposer();
            mailComposer.setToAddress(toAddresses);
            mailComposer.setCcAddress(toCcAddresses);
            mailComposer.setBccAddress(toBccAddresses);
            mailComposer.setSubject(subject);
            mailComposer.setMessage(message);
            mailComposer.send();
        }
        catch (Exception ex) {
            throw new Exception("Error executing Email Profile Send").initCause(ex);
        }
    }
}

