/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.janoslib.net.tcp;

import com.integpg.janoslib.logging.AppLog;
import com.integpg.janoslib.net.tcp.TcpServerEvent;
import com.integpg.janoslib.net.tcp.TcpServerListener;
import com.integpg.janoslib.system.JanosApplication;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;

public class TcpServer
implements Runnable {
    private final String _name;
    private TcpServerListener _listener = null;
    private ServerSocket _serverSocket;
    private final int _port;
    private Thread _thread;
    private boolean bServerRun = true;

    public TcpServer(int port) {
        this(String.format("%s TCP Server", JanosApplication.getName()), port);
    }

    public TcpServer(String name, int port) {
        this._name = name;
        this._port = port;
    }

    public void setTcpServerListener(TcpServerListener listener) {
        this._listener = listener;
    }

    public void start() {
        try {
            AppLog.info(String.format("Starting listener on port %d for the %s", this._port, this._name));
            this._serverSocket = new ServerSocket(this._port);
        }
        catch (IOException ex) {
            throw new RuntimeException(String.format("Unable to listen on port %d for the %s", this._port, this._name), ex);
        }
        try {
            this._thread = new Thread(this);
            this._thread.setName(this.getClass().getName() + ":" + this._port);
            this._thread.setDaemon(true);
            this._thread.start();
        }
        catch (RuntimeException ex) {
            throw new RuntimeException("Unable to start the server: " + ex.getMessage());
        }
    }

    public int getPort() {
        return this._serverSocket.getLocalPort();
    }

    public void stop() throws IOException {
        if (null != this._serverSocket) {
            AppLog.info(String.format("Stopping Server Socket on port %d for %s", this._port, this._name));
            this.bServerRun = false;
            this._serverSocket.close();
            AppLog.info(String.format("Server Socket on port %d is closed", this._port));
            try {
                this._thread.interrupt();
                this._thread.join();
            }
            catch (InterruptedException ex) {
                AppLog.error("Error stopping server socket: " + ex.getMessage());
            }
        }
    }

    @Override
    public void run() {
        try {
            AppLog.info("Listening for " + this._name + " clients on port " + this._port);
            while (this.bServerRun) {
                try {
                    Socket socket = this._serverSocket.accept();
                    if (this._listener == null) continue;
                    this._listener.clientConnected(new TcpServerEvent(this, socket));
                }
                catch (IOException ex) {
                    AppLog.error("Error accepting server socket connection", ex);
                    this.bServerRun = false;
                }
                catch (Exception ex) {
                    AppLog.error("Error accepting server socket connection", ex);
                }
            }
        }
        catch (Exception ex) {
            AppLog.error("Error accepting server socket connection: " + ex.getMessage());
            this.bServerRun = false;
        }
        try {
            this._serverSocket.close();
        }
        catch (IOException ex) {
            AppLog.error("Error closing server socket: " + ex.getMessage());
        }
        this._serverSocket = null;
        AppLog.info(String.format("Server Socket on port %d for %s is done.", this._port, this._name));
    }

    protected void finalize() throws Throwable {
        String message = "finalizing TcpServer...";
        AppLog.info(message);
        if (null != this._serverSocket) {
            this._serverSocket.close();
            AppLog.info(String.format("Server Socket on port %d is closed", this._port));
        }
    }
}

