/*
 * Decompiled with CFR 0.152.
 */
package com.integ.scripting;

import com.integ.scripting.exceptions.ScriptParserException;
import com.integ.scripting.exceptions.UnexpectedTokenException;
import com.integ.scripting.nodes.AbstractNode;
import com.integ.scripting.nodes.AssignmentNode;
import com.integ.scripting.nodes.BinaryNode;
import com.integ.scripting.nodes.LogicalNode;
import com.integ.scripting.nodes.UnaryNode;
import com.integ.scripting.nodes.ValueNode;
import com.integ.scripting.objects.AbstractObject;
import com.integ.scripting.objects.AbstractObjectCall;
import com.integ.scripting.objects.ArrayUtilsObject;
import com.integ.scripting.objects.BlockObject;
import com.integ.scripting.objects.ControlPanelLedObject;
import com.integ.scripting.objects.DateObject;
import com.integ.scripting.objects.DigitalInputObject;
import com.integ.scripting.objects.DoubleObject;
import com.integ.scripting.objects.EnvironObject;
import com.integ.scripting.objects.FileObject;
import com.integ.scripting.objects.FourTwentyInputObject;
import com.integ.scripting.objects.FourTwentyOutputObject;
import com.integ.scripting.objects.HexUtilsObject;
import com.integ.scripting.objects.IntObject;
import com.integ.scripting.objects.IoLogObject;
import com.integ.scripting.objects.JniorObject;
import com.integ.scripting.objects.MathObject;
import com.integ.scripting.objects.ReferenceObject;
import com.integ.scripting.objects.RegistryObject;
import com.integ.scripting.objects.RelayOutputObject;
import com.integ.scripting.objects.StringObject;
import com.integ.scripting.objects.TaskObject;
import com.integ.scripting.objects.TempProbeObject;
import com.integ.scripting.objects.TenVoltInputObject;
import com.integ.scripting.objects.TenVoltOutputObject;
import com.integ.scripting.objects.TimeObject;
import com.integ.tasker.lexer.Lexer;
import com.integ.tasker.lexer.Token;
import com.integ.tasker.lexer.TokenStream;
import com.integ.tasker.tasks.Scope;
import com.integpg.janoslib.collections.Queue;

public class ExpressionEngine {
    private static final String PARSE_STATEMENT_SPACES = " ";
    private static final String PARSE_ASSIGNMENT_SPACES = "  ";
    private static final String PARSE_EXPRESSION_SPACES = "  ";
    private static final String PARSE_LOGICAL_OR_SPACES = "   ";
    private static final String PARSE_LOGICAL_AND_SPACES = "    ";
    private static final String PARSE_EQUALITY_SPACES = "     ";
    private static final String PARSE_COMPARISON_SPACES = "      ";
    private static final String PARSE_TERM_SPACES = "       ";
    private static final String PARSE_FACTOR_SPACES = "        ";
    private static final String PARSE_UNARY_SPACES = "         ";
    private static final String PARSE_CALL_SPACES = "          ";
    private static final String PARSE_PRIMARY_SPACES = "           ";
    private boolean Debug = false;
    private final Queue<Token> _tokenQueue = new Queue();
    private final TokenStream _tokens = new TokenStream(this._tokenQueue);
    private final BlockObject _root = new BlockObject();
    private String _script;

    public boolean shouldDebug() {
        return this.Debug;
    }

    public void setDebug(boolean shouldDebug) {
        System.out.println("shouldDebug = " + shouldDebug);
        this.Debug = shouldDebug;
        this._tokens.printDebug(shouldDebug);
    }

    public void parse(String script) throws Exception {
        try {
            this._script = script;
            this._tokens.clear();
            Lexer.setDebug(this.Debug);
            Lexer.parse(this._tokenQueue, script);
            if (this.Debug) {
                for (int i = 0; i < this._tokenQueue.size(); ++i) {
                    Token token = this._tokenQueue.elementAt(i);
                    System.out.println(String.format("   token %d: %s", i, token.toString()));
                }
            }
            this._root.parse(this);
        }
        catch (Exception ex) {
            throw new RuntimeException(String.format("error parsing '%s'", script), ex);
        }
    }

    public Token currentToken() {
        return this._tokens.currentToken();
    }

    public Token nextToken() {
        if (!this._tokens.isEmpty()) {
            Token nextToken = this._tokens.nextToken();
            if (this.Debug) {
                System.out.println(String.format("   next token: %s", nextToken.toString()));
            }
            return nextToken;
        }
        if (this.Debug) {
            System.out.println("token stream is empty!");
        }
        return null;
    }

    public Token peekToken() {
        try {
            throw new RuntimeException("should not call peek");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(-99);
            return null;
        }
    }

    public Token eatToken() {
        Token currentToken = this._tokens.currentToken();
        this.nextToken();
        return currentToken;
    }

    public void expect(String expectedContent) throws UnexpectedTokenException {
        if (!this.currentToken().checkContent(expectedContent)) {
            throw new UnexpectedTokenException(expectedContent, this.currentToken());
        }
        if (!this.isEmpty()) {
            this.nextToken();
        }
    }

    public boolean isEmpty() {
        return this._tokens.isEmpty();
    }

    public AbstractNode parseStatement() throws ScriptParserException {
        if (this.Debug) {
            System.out.println(" parseStatement() " + this.currentToken());
        }
        AbstractNode abstractNode = this.parseExpression();
        return abstractNode;
    }

    public AbstractNode parseExpression() throws ScriptParserException {
        if (this.Debug) {
            System.out.println("  parseExpression() " + this.currentToken());
        }
        AbstractNode leftNode = this.parseAssignment();
        if (this.Debug) {
            System.out.println("  parseExpression() leftNode = " + leftNode);
        }
        if (null == leftNode) {
            try {
                throw new RuntimeException();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return leftNode;
    }

    public AbstractNode parseAssignment() throws ScriptParserException {
        if (this.Debug) {
            System.out.println("  parseAssignment() " + this.currentToken());
        }
        AbstractNode leftNode = this.parseLogicalOr();
        System.out.println("parseAssignment() leftNode = " + leftNode);
        if (this.Debug) {
            System.out.println("  parseAssignment() " + this.currentToken());
        }
        if (!this.isEmpty()) {
            switch (this.currentToken().getContent()) {
                case "=": {
                    this.nextToken();
                    if (!(leftNode instanceof ReferenceObject)) break;
                    return new AssignmentNode(leftNode, this.parseLogicalOr());
                }
            }
        }
        if (this.Debug) {
            System.out.println("  parseAssignment() leftNode = " + leftNode);
        }
        if (null == leftNode) {
            try {
                throw new RuntimeException();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return leftNode;
    }

    protected AbstractNode parseLogicalOr() throws ScriptParserException {
        if (this.Debug) {
            System.out.println("   parseLogicOr() " + this.currentToken());
        }
        AbstractNode leftNode = this.parseLogicalAnd();
        switch (this.currentToken().getContent()) {
            case "||": {
                Token operatorToken = this.eatToken();
                leftNode = new LogicalNode(operatorToken, leftNode, this.parseLogicalAnd());
            }
        }
        if (this.Debug) {
            System.out.println("   parseLogicalOr() leftNode = " + leftNode);
        }
        return leftNode;
    }

    protected AbstractNode parseLogicalAnd() throws ScriptParserException {
        if (this.Debug) {
            System.out.println("    parseLogicAnd() " + this.currentToken());
        }
        AbstractNode leftNode = this.parseEquality();
        switch (this.currentToken().getContent()) {
            case "&&": {
                Token operatorToken = this.eatToken();
                return new LogicalNode(operatorToken, leftNode, this.parseExpression());
            }
        }
        return leftNode;
    }

    protected AbstractNode parseEquality() throws ScriptParserException {
        if (this.Debug) {
            System.out.println("     parseEquality() " + this.currentToken());
        }
        AbstractNode leftNode = this.parseComparison();
        if (this.Debug) {
            System.out.println("     parseEquality() leftNode = " + leftNode);
        }
        if (this.Debug) {
            System.out.println("     --- parseEquality() " + this.currentToken());
        }
        switch (this.currentToken().getContent()) {
            case "==": {
                Token operatorToken = this.eatToken();
                return new LogicalNode(operatorToken, leftNode, this.parseExpression());
            }
            case "!=": {
                Token operatorToken = this.eatToken();
                leftNode = new LogicalNode(operatorToken, leftNode, this.parseLogicalAnd());
            }
        }
        return leftNode;
    }

    protected AbstractNode parseComparison() throws ScriptParserException {
        if (this.Debug) {
            System.out.println("      parseComparison() " + this.currentToken());
        }
        AbstractNode leftNode = this.parseTerm();
        if (this.Debug) {
            System.out.println("      parseComparison() leftNode = " + leftNode);
        }
        switch (this.currentToken().getContent()) {
            case "<": 
            case "<=": 
            case ">": 
            case ">=": {
                Token operatorToken = this.eatToken();
                return new LogicalNode(operatorToken, leftNode, this.parseExpression());
            }
        }
        return leftNode;
    }

    protected AbstractNode parseTerm() throws ScriptParserException {
        if (this.Debug) {
            System.out.println("       parseTerm() " + this.currentToken());
        }
        AbstractNode leftNode = this.parseFactor();
        if (this.Debug) {
            System.out.println("       parseTerm() leftNode = " + leftNode);
        }
        while (this.currentToken().checkContent("+", "-")) {
            Token operator = this.eatToken();
            AbstractNode rightNode = this.parseFactor();
            if (this.Debug) {
                System.out.println("       parseTerm() rightNode = " + rightNode);
            }
            leftNode = new BinaryNode(operator, leftNode, rightNode);
        }
        return leftNode;
    }

    protected AbstractNode parseFactor() throws ScriptParserException {
        if (this.Debug) {
            System.out.println("        parseFactor() " + this.currentToken());
        }
        AbstractNode leftNode = this.parseExp();
        if (this.Debug) {
            System.out.println("        parseFactor() leftNode = " + leftNode);
        }
        while (this.currentToken().checkContent("*", "/", "%")) {
            Token operatorToken = this.eatToken();
            AbstractNode rightNode = this.parseExp();
            if (this.Debug) {
                System.out.println("new binary node = " + leftNode + PARSE_STATEMENT_SPACES + operatorToken + PARSE_STATEMENT_SPACES + rightNode);
            }
            leftNode = new BinaryNode(operatorToken, leftNode, rightNode);
        }
        return leftNode;
    }

    protected AbstractNode parseExp() throws ScriptParserException {
        if (this.Debug) {
            System.out.println("        parseExp() " + this.currentToken());
        }
        AbstractNode leftNode = this.parseUnary();
        if (this.Debug) {
            System.out.println("        parseExp() leftNode = " + leftNode);
        }
        while (this.currentToken().checkContent("^")) {
            Token operatorToken = this.eatToken();
            AbstractNode rightNode = this.parseUnary();
            if (this.Debug) {
                System.out.println("new binary node = " + leftNode + PARSE_STATEMENT_SPACES + operatorToken + PARSE_STATEMENT_SPACES + rightNode);
            }
            leftNode = new BinaryNode(operatorToken, leftNode, rightNode);
        }
        return leftNode;
    }

    protected AbstractNode parseUnary() throws ScriptParserException {
        Token currentToken = this.currentToken();
        if (this.Debug) {
            System.out.println("         parseUnary() " + currentToken);
        }
        AbstractNode leftNode = null;
        if (currentToken.checkContent("-")) {
            Token operatorToken = this.eatToken();
            AbstractNode right = this.parseUnary();
            leftNode = new UnaryNode(operatorToken, right);
        }
        if (null == leftNode) {
            leftNode = this.parseCall();
        }
        if (this.Debug) {
            System.out.println("         parseUnary leftNode = " + leftNode);
        }
        return leftNode;
    }

    protected AbstractNode parseCall() throws ScriptParserException {
        Token currentToken = this.currentToken();
        if (this.Debug) {
            System.out.println("          parseCall() " + currentToken);
        }
        AbstractNode leftNode = null;
        if (currentToken.checkType(40)) {
            this.nextToken();
            leftNode = this.parseExpression();
            this.expect(")");
        } else {
            leftNode = this.parsePrimary();
            if (null != leftNode && (leftNode instanceof AbstractObjectCall || leftNode instanceof ReferenceObject)) {
                ((AbstractObject)leftNode).parse(this);
            }
        }
        if (this.Debug) {
            System.out.println("          parseCall() leftNode = " + leftNode);
        }
        return leftNode;
    }

    private AbstractNode parsePrimary() throws ScriptParserException {
        Token currentToken = this.currentToken();
        if (this.Debug) {
            System.out.println(String.format("%sparsePrimary(): %s", PARSE_PRIMARY_SPACES, this.currentToken().toString()));
        }
        if (currentToken.checkType(3)) {
            if (this.currentToken().content.contains(".")) {
                return new ValueNode(Double.valueOf(this.eatToken().content));
            }
            return new ValueNode(Integer.valueOf(this.eatToken().content));
        }
        if (currentToken.checkType(16)) {
            if (currentToken.checkContent("true")) {
                return new ValueNode(this.eatToken().content);
            }
            if (currentToken.checkContent("false")) {
                return new ValueNode(this.eatToken().content);
            }
        }
        if (currentToken.checkType(4)) {
            return new ValueNode(this.eatToken().getContent());
        }
        AbstractObject abstractObject = null;
        abstractObject = currentToken.checkContent("din") ? new DigitalInputObject() : (currentToken.checkContent("rout") ? new RelayOutputObject() : (currentToken.checkContent("iin") ? new FourTwentyInputObject() : (currentToken.checkContent("iout") ? new FourTwentyOutputObject() : (currentToken.checkContent("vin") ? new TenVoltInputObject() : (currentToken.checkContent("vout") ? new TenVoltOutputObject() : (currentToken.checkContent("fpled") ? new ControlPanelLedObject() : (currentToken.checkContent("jnior") ? new JniorObject() : (currentToken.checkContent("arrayutils") ? new ArrayUtilsObject() : (currentToken.checkContent("hexutils") ? new HexUtilsObject() : (currentToken.checkContent("date") ? new DateObject() : (currentToken.checkContent("file") ? new FileObject() : (currentToken.checkContent("task") ? new TaskObject() : (currentToken.checkContent("time") ? new TimeObject() : (currentToken.checkContent("string") ? new StringObject() : (currentToken.checkContent("temp") ? new TempProbeObject() : (currentToken.checkContent("env") ? new EnvironObject() : (currentToken.checkContent("reg") || currentToken.checkContent("registry") ? new RegistryObject() : (currentToken.checkContent("math") ? new MathObject() : (currentToken.checkContent("int") ? new IntObject() : (currentToken.checkContent("double") ? new DoubleObject() : (currentToken.checkContent("iolog") ? new IoLogObject() : new ReferenceObject())))))))))))))))))))));
        return abstractObject;
    }

    public Object execute(Scope scope) {
        Object result = this._root.execute(scope);
        return result;
    }
}

