/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker.web.webrequest;

import com.integ.tasker.devices.DeviceCollection;
import com.integ.tasker.devices.DeviceProfile;
import com.integ.tasker.devices.EthernetDevice;
import com.integ.tasker.tasks.Task;
import com.integ.tasker.tasks.TaskCollection;
import com.integ.tasker.workspaces.WorkspaceCollection;
import com.integ.tasker.workspaces.WorkspaceFile;
import com.integpg.janoslib.http.server.HttpContext;
import com.integpg.janoslib.http.server.HttpResponse;
import com.integpg.janoslib.http.server.WebHandler;
import com.integpg.janoslib.logger.AppLog;
import com.integpg.janoslib.text.QuickDateFormat;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Json;

public class GetTaskDevicesRequestHandler
implements WebHandler {
    private static final QuickDateFormat QUICK_DATE_FORMAT = new QuickDateFormat();
    private PrintWriter _out;

    @Override
    public void processRequest(HttpContext httpContext) {
        try {
            System.out.println(String.format("%lld GetLoadedTasksRequestHandler request received", System.currentTimeMillis()));
            AppLog.info(String.format("Processing %s", httpContext.getRequest().getRequestedURI()));
            HttpResponse response = httpContext.getResponse();
            response.setContentType("application/json");
            this._out = response.getWriter();
            try {
                Json json = new Json();
                WorkspaceFile[] loadedWorkspaces = WorkspaceCollection.getWorkspacesArray();
                Json[] workspacesJsonArray = new Json[loadedWorkspaces.length];
                for (int i = 0; i < loadedWorkspaces.length; ++i) {
                    WorkspaceFile workspace = loadedWorkspaces[i];
                    workspacesJsonArray[i] = new Json();
                    workspacesJsonArray[i].put("name", (Object)workspace.getName());
                    workspacesJsonArray[i].put("version", (Object)workspace.getVersion());
                    workspacesJsonArray[i].put("enabled", (Object)workspace.isEnabled());
                    workspacesJsonArray[i].put("lastModifiedTime", (Object)QUICK_DATE_FORMAT.format(workspace.getFile().lastModified()));
                    if (!workspace.isEnabled()) continue;
                    TaskCollection taskCollection = workspace.getTasksCollection();
                    Task[] taskArray = taskCollection.getTasksArray();
                    Json[] tasksJsonArray = new Json[taskArray.length];
                    for (int taskIndex = 0; taskIndex < taskArray.length; ++taskIndex) {
                        Task task = taskArray[taskIndex];
                        tasksJsonArray[taskIndex] = new Json();
                        tasksJsonArray[taskIndex].put("name", (Object)task.Name);
                        if (null != task.Description) {
                            tasksJsonArray[taskIndex].put("description", (Object)task.Description);
                        }
                        ArrayList<Json> devicesActionJsonList = task.getDeviceActionJsonList();
                        Json[] devicesActionJsonArray = new Json[devicesActionJsonList.size()];
                        for (int deviceIndex = 0; deviceIndex < devicesActionJsonList.size(); ++deviceIndex) {
                            Json deviceActionJson;
                            devicesActionJsonArray[deviceIndex] = deviceActionJson = devicesActionJsonList.get(deviceIndex);
                        }
                        tasksJsonArray[taskIndex].put("devicesReferenced", (Object)devicesActionJsonArray);
                    }
                    workspacesJsonArray[i].put("tasks", (Object)tasksJsonArray);
                    DeviceCollection deviceCollection = workspace.getDevicesCollection();
                    DeviceProfile[] deviceArray = deviceCollection.getDevicesArray();
                    Json[] deviceJsonArray = new Json[deviceArray.length];
                    for (int deviceIndex = 0; deviceIndex < deviceArray.length; ++deviceIndex) {
                        DeviceProfile device = deviceArray[deviceIndex];
                        deviceJsonArray[deviceIndex] = new Json();
                        deviceJsonArray[deviceIndex].put("name", (Object)device.Name);
                        if (!(device instanceof EthernetDevice)) continue;
                        deviceJsonArray[deviceIndex].put("ipAddress", (Object)((EthernetDevice)device).getIpAddress());
                        deviceJsonArray[deviceIndex].put("port", ((EthernetDevice)device).getPort());
                    }
                    workspacesJsonArray[i].put("devices", (Object)deviceJsonArray);
                }
                json.put("workspaces", (Object)workspacesJsonArray);
                this._out.print(json.toString());
            }
            catch (Exception ex) {
                this._out.println("error: " + ex.getMessage());
                ex.printStackTrace();
            }
            System.out.println(String.format("%lld GetLoadedTasksRequestHandler request done", System.currentTimeMillis()));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            try {
                httpContext.getRequest().close();
            }
            catch (IOException ex1) {
                ex1.printStackTrace();
            }
        }
    }
}

