/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker;

import com.integ.tasker.Config;
import com.integ.tasker.TaskerAsciiCommandClient;
import com.integpg.janoslib.logger.AppLog;
import com.integpg.janoslib.net.TcpServer;
import com.integpg.janoslib.net.TcpServerEvent;
import com.integpg.janoslib.net.TcpServerListener;
import com.integpg.janoslib.text.QuickDateFormat;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

public class TaskerAsciiCommandServer
implements TcpServerListener {
    private static final QuickDateFormat QUICK_DATE_FORMAT = new QuickDateFormat();
    private final TcpServer _asciiServer = new TcpServer("tasker-ascii-server", Config.getAsciiCommandServerPort());

    public TaskerAsciiCommandServer() {
        this._asciiServer.setTcpServerListener(this);
    }

    @Override
    public void clientConnected(TcpServerEvent evt) {
        System.out.println(String.format("client connected at %s", QUICK_DATE_FORMAT.format()));
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            Socket socket = evt.getSocket();
            String socketInfo = socket.getInetAddress().getHostAddress() + ":" + socket.getPort();
            System.out.println(String.format("%s connected at %s", socketInfo, QUICK_DATE_FORMAT.format()));
            inputStream = socket.getInputStream();
            outputStream = socket.getOutputStream();
            TaskerAsciiCommandClient asciiCommandClient = new TaskerAsciiCommandClient(socketInfo, inputStream, outputStream);
            asciiCommandClient.start();
        }
        catch (IOException ex) {
            AppLog.error(ex);
        }
    }

    public void start() {
        AppLog.info("start tasker ascii tcp server");
        this._asciiServer.start();
    }
}

