/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker.devices;

import com.integ.tasker.devices.DeviceProfile;
import com.integ.tasker.devices.RecvDevice;
import com.integ.tasker.devices.SendDevice;
import com.integ.tasker.tasks.Scope;
import com.integ.tasker.web.messages.ErrorMessage;
import com.integpg.janoslib.messagepump.MessagePumpEngine;
import com.integpg.janoslib.utils.HexUtils;
import java.io.DataInputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Json;

public class EthernetDevice
extends DeviceProfile
implements SendDevice,
RecvDevice {
    private String _ipAddress;
    private int _port;
    private String _protocol = "tcp";
    private Socket _tcpSocket = null;
    private DatagramSocket _udpSocket = null;

    public EthernetDevice(Json json) {
        super(json);
        try {
            Json paramsJson = (Json)json.get("Params");
            this._ipAddress = paramsJson.getString("IpAddress");
            this._port = paramsJson.getInt("Port");
            LOG.info(String.format("ipAddress: %s, port: %d", this._ipAddress, this._port));
            if (paramsJson.containsKey("Protocol")) {
                this._protocol = paramsJson.getString("Protocol");
                LOG.info(String.format("protocol: %s", this._protocol));
            }
        }
        catch (Throwable ex) {
            Throwable throwable = new Exception("unable to load " + this.Name).initCause(ex);
            LOG.error(throwable);
            ErrorMessage message = new ErrorMessage(throwable);
            MessagePumpEngine.postMessage(message.build());
        }
    }

    public String getIpAddress() {
        return this._ipAddress;
    }

    public int getPort() {
        return this._port;
    }

    @Override
    public void send(byte[] bytes) throws Exception {
        if ("udp".equalsIgnoreCase(this._protocol)) {
            this.sendUdp(bytes);
        } else {
            this.sendTcp(bytes);
        }
    }

    private void sendTcp(byte[] bytes) throws Exception {
        String host = this.getIpAddress();
        int port = this.getPort();
        for (int retries = 1; 0 <= retries; --retries) {
            try {
                if (null == this._tcpSocket) {
                    LOG.info(String.format("connecting to %s", this.Name));
                    this._tcpSocket = new Socket(host, port);
                }
                if (null == this._tcpSocket) break;
                LOG.info(String.format("sending: %s", new String(bytes)));
                this._tcpSocket.getOutputStream().write(bytes);
                this._tcpSocket.getOutputStream().flush();
                break;
            }
            catch (Exception ex) {
                this.close();
                if (false != retries) continue;
                throw ex;
            }
        }
    }

    private void sendUdp(byte[] bytes) throws Exception {
        String host = this.getIpAddress();
        int port = this.getPort();
        try {
            if (null == this._udpSocket) {
                LOG.info(String.format("connecting to %s", this.Name));
                this._udpSocket = new DatagramSocket();
            }
            if (null != this._udpSocket) {
                LOG.info(String.format("sending: %s", new String(bytes)));
                DatagramPacket sendPacket = new DatagramPacket(bytes, bytes.length, InetAddress.getByName(host), port);
                this._udpSocket.send(sendPacket);
            }
        }
        catch (Exception ex) {
            this.close();
        }
    }

    @Override
    public void receive(Scope scope) throws Exception {
        try {
            if (null != this._tcpSocket) {
                System.out.println("tcp receive");
                DataInputStream dis = new DataInputStream(this._tcpSocket.getInputStream());
                byte[] newArray = new byte[dis.available()];
                int bytesRead = dis.read(newArray);
                scope.setVariable(String.format("%s_buffer", this.LowercaseName), newArray);
                DeviceProfile.LOG.info(String.format("%s read %d bytes: %s", this.Name, bytesRead, HexUtils.bytesToHex(newArray)));
            } else if (null != this._udpSocket) {
                System.out.println("udp receive");
                byte[] data = new byte[1024];
                DatagramPacket packet = new DatagramPacket(data, data.length);
                this._udpSocket.receive(packet);
                data = packet.getData();
                if (0 < data.length) {
                    scope.setVariable(String.format("%s_buffer", this.LowercaseName), data);
                    DeviceProfile.LOG.info(String.format("%s read %d bytes: %s", this.Name, data.length, HexUtils.bytesToHex(data)));
                }
            }
        }
        catch (Exception ex) {
            this.close();
            throw ex;
        }
    }

    public void close() throws Exception {
        try {
            if (null != this._tcpSocket) {
                LOG.info(String.format("closing %s", this.Name));
                this._tcpSocket.close();
                this._tcpSocket = null;
            } else if (null != this._udpSocket) {
                LOG.info(String.format("closing %s", this.Name));
                this._udpSocket.close();
                this._udpSocket = null;
            }
        }
        catch (Exception ex) {
            this._tcpSocket = null;
            throw ex;
        }
    }
}

