/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker.triggers;

import com.integ.tasker.tasks.Scope;
import com.integ.tasker.tasks.Task;
import com.integ.tasker.tasks.TaskCollection;
import com.integ.tasker.triggers.Reset;
import com.integ.tasker.triggers.TriggerProfile;
import com.integ.tasker.triggers.TriggersConfiguration;
import com.integ.tasker.web.messages.ErrorMessage;
import com.integ.tasker.web.messages.WorkspaceStatusMessage;
import com.integ.tasker.workspaces.WorkspaceFile;
import com.integpg.janoslib.messagepump.MessagePumpEngine;

public abstract class Trigger {
    protected STATE _currentState = STATE.WATCHING;
    protected WorkspaceFile _workspaceConfigurationFile;
    private TriggerProfile _triggerProfile;
    protected Reset _reset;
    private String _taskName;
    private long _lastTriggerTime;
    protected Scope _scope = new Scope();

    public void setTriggerProfile(TriggerProfile triggerProfile) {
        this._triggerProfile = triggerProfile;
    }

    public String getName() {
        return this._triggerProfile.getName();
    }

    public void setReset(Reset reset) {
        this._reset = reset;
    }

    public void setTaskName(String taskName) {
        this._taskName = taskName;
    }

    public void setWorkspaceConfigurationFile(WorkspaceFile workspaceConfigurationFile) {
        this._workspaceConfigurationFile = workspaceConfigurationFile;
        WorkspaceStatusMessage workspaceStatusMessage = this._workspaceConfigurationFile.getWorkspaceStatusMessage();
    }

    protected void trigger() {
        if (STATE.WATCHING == this._currentState) {
            TriggersConfiguration.LOG.info(String.format("trigger %s has been triggered", this.getName()));
            if (null != this._reset) {
                this._currentState = STATE.TRIGGERED;
            }
            this._lastTriggerTime = System.currentTimeMillis();
            this.executeTask();
            WorkspaceStatusMessage workspaceStatusMessage = this._workspaceConfigurationFile.getWorkspaceStatusMessage();
            MessagePumpEngine.postMessage(workspaceStatusMessage.build());
        }
    }

    private void executeTask() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Task task = TaskCollection.GLOBAL.getByTaskName(Trigger.this._taskName);
                    if (null != task) {
                        Trigger.this._scope.setVariable("trigger.time", System.currentTimeMillis());
                        task.execute(String.format("Trigger: %s", Trigger.this.getName()), Trigger.this._scope);
                    }
                }
                catch (Throwable ex) {
                    Exception throwable = new Exception("error trigger executing task '" + Trigger.this._taskName + "' by name", ex);
                    TriggersConfiguration.LOG.error((Object)throwable);
                    ErrorMessage message = new ErrorMessage(throwable);
                    MessagePumpEngine.postMessage(message.build());
                }
            }
        }).start();
    }

    public boolean isTriggered() {
        return STATE.TRIGGERED == this._currentState;
    }

    public void resetTrigger() {
        TriggersConfiguration.LOG.info(String.format("trigger %s has been reset", this.getName()));
        this._currentState = STATE.WATCHING;
        this._lastTriggerTime = 0L;
        WorkspaceStatusMessage workspaceStatusMessage = this._workspaceConfigurationFile.getWorkspaceStatusMessage();
        MessagePumpEngine.postMessage(workspaceStatusMessage.build());
    }

    public void checkForTrigger() throws Throwable {
    }

    public long getLastTriggerTime() {
        return this._lastTriggerTime;
    }

    protected static enum STATE {
        WATCHING,
        TRIGGERED;

    }
}

