/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker.devices;

import com.integ.tasker.devices.DeviceProfile;
import com.integ.tasker.devices.EthernetDevice;
import com.integ.tasker.devices.OSCDevice;
import com.integ.tasker.devices.OSCServerDevice;
import com.integ.tasker.devices.SNMPDevice;
import com.integ.tasker.devices.SerialDevice;
import com.integ.tasker.devices.TCPServerDevice;
import com.integ.tasker.devices.UDPServerDevice;
import com.integ.tasker.devices.projectors.ProjectorFactory;
import com.integ.tasker.devices.soundprocessors.SoundProcessorFactory;
import java.util.Json;

public class DeviceFactory {
    public static DeviceProfile getDevice(Json json) throws Throwable {
        String typeString;
        switch (typeString = json.getString("Type")) {
            case "EthernetDevice": {
                return new EthernetDevice(json);
            }
            case "SNMPDevice": {
                return new SNMPDevice(json);
            }
            case "OSCServerDevice": {
                return new OSCServerDevice(json);
            }
            case "OSCDevice": {
                return new OSCDevice(json);
            }
            case "ProjectorDevice": {
                return ProjectorFactory.getDevice(json);
            }
            case "SerialDevice": {
                return new SerialDevice(json);
            }
            case "SoundProcessorDevice": {
                return SoundProcessorFactory.getDevice(json);
            }
            case "TCPServerDevice": {
                return new TCPServerDevice(json);
            }
            case "UDPServerDevice": {
                return new UDPServerDevice(json);
            }
        }
        throw new Exception(String.format("Unknown Device Type: %s in %s", typeString, json.toString()));
    }
}

