class DeviceObject extends TaskerObject {
    constructor(name) {
        super();
        this.Name = name; // || 'new Device';
    }


    editTemplate() {
        var template = 'editTemplate() not overridden';
        return template;
    }
}



class EthernetDevice extends DeviceObject {
    constructor(name, ipAddress, port) {
        super(name);
        this.Type = 'EthernetDevice';
        this.Params = { Protocol: 'tcp' };
    }


    editTemplate() {
        var protocolGuid = guid();
        var template = '<b>Ethernet:</b> IP Address <input type="text" class="form-control" ng-model="device.Params.IpAddress" ' +
            '  style="width:150px;" name="ip-address-' + guid() + '" required> ' +
            ' Port <input type="number" class="form-control" ng-model="device.Params.Port" ' +
            '  style="width:100px;" name="port-' + guid() + '" required>' +
            ' <input type="radio" id="udp" name="protocol-' + protocolGuid + '" ng-model="device.Params.Protocol" value="udp"> ' +
            ' <label for="protocol-' + protocolGuid + '">UDP</label> ' +
            ' <input type="radio" id="tcp" name="protocol-' + protocolGuid + '" ng-model="device.Params.Protocol" value="tcp"> ' +
            ' <label for="protocol-' + protocolGuid + '">TCP</label> ';
        return template;
    }
}



class TCPServerDevice extends DeviceObject {
    constructor(name) {
        super(name);
        this.Type = 'TCPServerDevice';
        this.Params = { Port: 6000 };
    }


    editTemplate() {
        var template = '<b>TCP Server:</b> '+
            ' Port <input type="number" class="form-control" ng-model="device.Params.Port" ' +
            '  style="width:100px;" name="port-' + guid() + '" required>';
        return template;
    }
}



class SNMPDevice extends DeviceObject {
    constructor(name) {
        super(name);
        this.Type = 'SNMPDevice';
        this.Params = { Port: 162, CommunityName: 'public' };
    }


    editTemplate() {
        var template = '<b>SNMP:</b> IP Address <input type="text" class="form-control" ng-model="device.Params.IpAddress" ' +
            '  style="width:150px;" name="ip-address-' + guid() + '" required> ' +
            ' UDP Port <input type="number" class="form-control" ng-model="device.Params.Port" ' +
            '  style="width:100px;" name="port-' + guid() + '" required>' +
            ' Community Name <input type="text" class="form-control" ng-model="device.Params.CommunityName" ' +
            '  style="width:200px;" name="community-name-' + guid() + '" required>';
        return template;
    }
}



class OSCServerDevice extends DeviceObject {
    constructor(name) {
        super(name);
        this.Type = 'OSCServerDevice';
        this.Params = { Protocol: 'udp', Port: 5000 };
    }


    editTemplate() {
        var protocolGuid = guid();
        var template = '<b>OSC Server:</b> '+
            ' &nbsp;&nbsp;&nbsp; Port <input type="number" class="form-control" ng-model="device.Params.Port" ' +
            '  style="width:100px;" name="port-' + guid() + '" required>' +
            ' <input type="radio" id="udp" name="protocol-' + protocolGuid + '" ng-model="device.Params.Protocol" value="udp"> ' +
            ' <label for="protocol-' + protocolGuid + '">UDP</label> ' +
            ' <input type="radio" id="tcp" name="protocol-' + protocolGuid + '" ng-model="device.Params.Protocol" value="tcp"> ' +
            ' <label for="protocol-' + protocolGuid + '">TCP</label> ';
        return template;
    }
}



class OSCDevice extends DeviceObject {
    constructor(name) {
        super(name);
        this.Type = 'OSCDevice';
        this.Params = { Protocol: 'udp', Port: 5000 };
    }


    editTemplate() {
        var protocolGuid = guid();
        var template = '<b>OSC Device:</b> IP Address <input type="text" class="form-control" ng-model="device.Params.IpAddress" ' +
            '  style="width:150px;" name="ip-address-' + guid() + '" required> '+
            ' Port <input type="number" class="form-control" ng-model="device.Params.Port" ' +
            '  style="width:100px;" name="port-' + guid() + '" required>' +
            ' <input type="radio" id="udp" name="protocol-' + protocolGuid + '" ng-model="device.Params.Protocol" value="udp"> ' +
            ' <label for="protocol-' + protocolGuid + '">UDP</label> ' +
            ' <input type="radio" id="tcp" name="protocol-' + protocolGuid + '" ng-model="device.Params.Protocol" value="tcp"> ' +
            ' <label for="protocol-' + protocolGuid + '">TCP</label> ';
        return template;
    }
}



class SerialDevice extends DeviceObject {
    constructor(name) {
        super(name);
        this.Type = 'SerialDevice';
        this.Params = { Port: 'aux' };
    }


    editTemplate() {
        var protocolGuid = guid();
        var template = '<i class="fa fa-info-circle" style="color: #428bca; position: relative; margin-left: -18px;" data-toggle="tooltip"' +
            ' title="Go to the main webUI to configure the serial port settings"></i>' +
            ' <b>Serial Device:</b>' +
            ' &nbsp;&nbsp;&nbsp;<input type="radio" id="udp" name="protocol-' + protocolGuid + '" ng-model="device.Params.Port" value="aux"> ' +
            ' <label for="protocol-' + protocolGuid + '">AUX</label> ' +
            ' &nbsp;&nbsp;&nbsp;<input type="radio" id="tcp" name="protocol-' + protocolGuid + '" ng-model="device.Params.Port" value="com"> ' +
            ' <label for="protocol-' + protocolGuid + '">COM</label>';
        return template;
    }
}



class ProjectorDevice extends DeviceObject {
    constructor(name) {
        super(name);
        this.Type = 'ProjectorDevice';
    }


    editTemplate() {
        var template = '<div>\r\n' +
            '<b>Projector:</b> Type <select class="form-control" ng-model="device.Params.ProjectorType"' +
            '  ng-options="device.Type as device.Name for device in controller.getProjectorDevices()">\r\n' +
            ' </select>\r\n' +
            ' <select class="form-control" ng-model="device.Params.CommType" ng-show="deviceType.EthernetDefaults && deviceType.SerialDefaults">\r\n' +
            '   <option value="">Ethernet</option>\r\n' +
            '   <option value="serial">Serial</option>\r\n' +
            ' </select>\r\n' +
            '<span ng-show="deviceType.EthernetDefaults && (!deviceType.SerialDefaults || !device.Params.CommType || ((undefined != device.Params.CommType) && (\'\' == device.Params.CommType)))">\r\n' +
            ' IP Address <input type="text" class="form-control" ng-model="device.Params.IpAddress" \r\n' +
            '  style="width:125px;" name="ip-address-' + guid() + '" required>\r\n' +
            ' TCP Port <input type="number" class="form-control" ng-model="device.Params.Port" \r\n' +
            '  style="width:100px;" name="port-' + guid() + '" placeholder="{{deviceType.EthernetDefaults.DefaultPort}}">\r\n' +
            ' <span ng-if="device.Params.ProjectorType.startsWith(\'barco\')">\r\n' +
            '  Username <input type="text" class="form-control" ng-model="device.Params.Username" \r\n' +
            '   style="width:100px;" name="username-' + guid() + '" required>\r\n' +
            '  Password <input type="password" class="form-control" ng-model="device.Params.Password" \r\n' +
            '   style="width:100px;" name="password-' + guid() + '" required>\r\n' +
            ' </span>' +
            '</span>' +
            '<span ng-show="deviceType.SerialDefaults && (!deviceType.EthernetDefaults || ((undefined != device.Params.CommType) && (\'serial\' == device.Params.CommType)))">\r\n' +
            ' Baud Rate <select class="form-control" ng-model="device.Params.BaudRate">\r\n' +
            '   <option value="" disabled selected>{{deviceType.SerialDefaults.BaudRate}}</option>\r\n' +
            '   <option>9600</option>\r\n' +
            '   <option>115200</option>\r\n' +
            ' </select>\r\n' +
            ' Data Bits <select class="form-control" ng-model="device.Params.DataBits">\r\n' +
            '   <option value="" disabled selected>{{deviceType.SerialDefaults.DataBits}}</option>\r\n' +
            '   <option>7</option>\r\n' +
            '   <option>8</option>\r\n' +
            ' </select>\r\n' +
            ' Stop Bits <select class="form-control" ng-model="device.Params.StopBits">\r\n' +
            '   <option value="" disabled selected>1</option>\r\n' +
            '   <option>1</option>\r\n' +
            '   <option>1.5</option>\r\n' +
            '   <option>2</option>\r\n' +
            ' </select>\r\n' +
            ' Parity <select class="form-control" ng-model="device.Params.Parity">\r\n' +
            '   <option value="" selected>None</option>\r\n' +
            '   <option>Even</option>\r\n' +
            '   <option>Odd</option>\r\n' +
            ' </select>\r\n' +
            '</span></div>';
        return template;
        // var template = '<b>Projector:</b> Type <select class="form-control" ng-model="device.Params.ProjectorType"' +
        //     '  ng-options="device.Type as device.Name for device in controller.getProjectorDevices()">\r\n' +
        //     ' </select>\r\n' +
        //     ' <select class="form-control" ng-model="device.Params.CommType">\r\n' +
        //     '   <option value="">Ethernet</option>\r\n' +
        //     '   <option value="serial">Serial</option>\r\n' +
        //     ' </select>\r\n' +
        //     '<span ng-if="\"serial\" != device.Params.CommType">\r\n' +
        //     ' IP Address <input type="text" class="form-control" ng-model="device.Params.IpAddress" \r\n' +
        //     '  style="width:150px;" name="ip-address-' + guid() + '" required>\r\n' +
        //     ' TCP Port <input type="number" class="form-control" ng-model="device.Params.Port" \r\n' +
        //     '  style="width:100px;" name="port-' + guid() + '" placeholder="{{controller.getProjectorForType(device.Params.ProjectorType).DefaultPort}}">\r\n' +
        //     ' <span ng-if="controller.getProjectorForType(device.Params.ProjectorType).PasswordReqired">\r\n' +
        //     '   Username <input type="text" class="form-control" ng-model="device.Params.Username" \r\n' +
        //     '     style="width:100px;" name="username-' + guid() + '" required>\r\n' +
        //     '   Password <input type="password" class="form-control" ng-model="device.Params.Password" \r\n' +
        //     '     style="width:100px;" name="password-' + guid() + '" required>\r\n' +
        //     ' </span>' +
        //     '</span>' +
        //     '<span ng-if="\"serial\" == device.Params.CommType">\r\n' +
        //     ' Baud Rate <input type="text" class="form-control" ng-model="device.Params.IpAddress" \r\n' +
        //     '  style="width:150px;" name="ip-address-' + guid() + '" required>\r\n' +
        //     ' TCP Port <input type="number" class="form-control" ng-model="device.Params.Port" \r\n' +
        //     '  style="width:100px;" name="port-' + guid() + '" placeholder="{{controller.getProjectorForType(device.Params.ProjectorType).DefaultPort}}">\r\n' +
        //     ' <span ng-if="controller.getProjectorForType(device.Params.ProjectorType).PasswordReqired">\r\n' +
        //     '   Username <input type="text" class="form-control" ng-model="device.Params.Username" \r\n' +
        //     '     style="width:100px;" name="username-' + guid() + '" required>\r\n' +
        //     '   Password <input type="password" class="form-control" ng-model="device.Params.Password" \r\n' +
        //     '     style="width:100px;" name="password-' + guid() + '" required>\r\n' +
        //     ' </span>' +
        //     '</span>';
        // return template;
    }
}



class SoundProcessorDevice extends DeviceObject {
    constructor(name) {
        super(name);
        this.Type = 'SoundProcessorDevice';
    }


    editTemplate() {
        var template = '<div>\r\n' +
            '<b>Sound Processor:</b> Type <select class="form-control" ng-model="device.Params.SoundProcessorType"' +
            '  ng-options="device.Type as device.Name for device in controller.getSoundProcessorDevices()">\r\n' +
            ' </select>\r\n' +
            ' <select class="form-control" ng-model="device.Params.CommType" ng-show="deviceType.EthernetDefaults && deviceType.SerialDefaults">\r\n' +
            '   <option value="">Ethernet</option>\r\n' +
            '   <option value="serial">Serial</option>\r\n' +
            ' </select>\r\n' +
            '<span ng-show="deviceType.EthernetDefaults && (!deviceType.SerialDefaults || !device.Params.CommType || ((undefined != device.Params.CommType) && (\'\' == device.Params.CommType)))">\r\n' +
            ' IP Address <input type="text" class="form-control" ng-model="device.Params.IpAddress" \r\n' +
            '  style="width:125px;" name="ip-address-' + guid() + '" required>\r\n' +
            ' TCP Port <input type="number" class="form-control" ng-model="device.Params.Port" \r\n' +
            '  style="width:100px;" name="port-' + guid() + '" placeholder="{{deviceType.EthernetDefaults.DefaultPort}}">\r\n' +
            ' <span ng-if="device.Params.ProjectorType.startsWith(\'barco\')">\r\n' +
            '  Username <input type="text" class="form-control" ng-model="device.Params.Username" \r\n' +
            '   style="width:100px;" name="username-' + guid() + '" required>\r\n' +
            '  Password <input type="password" class="form-control" ng-model="device.Params.Password" \r\n' +
            '   style="width:100px;" name="password-' + guid() + '" required>\r\n' +
            ' </span>' +
            '</span>' +
            '<span ng-show="deviceType.SerialDefaults && (!deviceType.EthernetDefaults || ((undefined != device.Params.CommType) && (\'serial\' == device.Params.CommType)))">\r\n' +
            ' Baud Rate <select class="form-control" ng-model="device.Params.BaudRate">\r\n' +
            '   <option value="" disabled selected>{{deviceType.SerialDefaults.BaudRate}}</option>\r\n' +
            '   <option>9600</option>\r\n' +
            '   <option>115200</option>\r\n' +
            ' </select>\r\n' +
            ' Data Bits <select class="form-control" ng-model="device.Params.DataBits">\r\n' +
            '   <option value="" disabled selected>{{deviceType.SerialDefaults.DataBits}}</option>\r\n' +
            '   <option>7</option>\r\n' +
            '   <option>8</option>\r\n' +
            ' </select>\r\n' +
            ' Stop Bits <select class="form-control" ng-model="device.Params.StopBits">\r\n' +
            '   <option value="" disabled selected>1</option>\r\n' +
            '   <option>1</option>\r\n' +
            '   <option>1.5</option>\r\n' +
            '   <option>2</option>\r\n' +
            ' </select>\r\n' +
            ' Parity <select class="form-control" ng-model="device.Params.Parity">\r\n' +
            '   <option value="" selected>None</option>\r\n' +
            '   <option>Even</option>\r\n' +
            '   <option>Odd</option>\r\n' +
            ' </select>\r\n' +
            '</span></div>';
        return template;
    }
}



class ModbusDevice extends DeviceObject {
    constructor(name) {
        super(name);
        this.Type = 'ModbusDevice';
        this.Params = { Port: 502 };
    }


    editTemplate() {
        var template = 'IP Address <input type="text" class="form-control" ng-model="device.Params.IpAddress" ' +
            '  style="width:150px;" name="modbus-ip-address-' + guid() + '" required> ' +
            ' TCP Port <input type="number" class="form-control" ng-model="device.Params.Port" ' +
            '  style="width:100px;" name="modbus-port-' + guid() + '" required>'
        return template;
    }
}



class UDPServerDevice extends DeviceObject {
    constructor(name) {
        super(name);
        this.Type = 'UDPServerDevice';
        this.Params = { Port: 5000 };
    }


    editTemplate() {
        var protocolGuid = guid();
        var template = '<b>UDP Server:</b> '+
            ' Port <input type="number" class="form-control" ng-model="device.Params.Port" ' +
            '  style="width:100px;" name="udpserver-port-' + guid() + '" required>';
        return template;
    }
}