function parseControlPanelAction(json) {
    var method = json.Method;

    switch (method) {
        case 'SetLed':
            return new SetLed();

        case 'PlayAlarm':
            return new PlayAlarm();

        case 'SilenceAlarm':
            return new SilenceAlarm();

        default:
            throw new Error('Unknown Control Panel Method: ' + JSON.stringify(json, null, 2));
    }
}



class ControlPanel extends Action {
    constructor() {
        super();
        this.Type = 'ControlPanel';
        this.Method = 'void';
        this.Params = {};
    }
}


class SetLed extends ControlPanel {
    constructor(channel, mode) {
        super();
        this.Method = 'SetLed';
        this.Params.Channel = channel;
        this.Params.Mode = mode;
    }

    editTemplate() {
        var template = 'Set Control Panel LED Channel <input name="' + guid() + '" required class="form-control" type="text" ng-model="action.Params.Channel" style="width:50px;" data-toggle="tooltip" title="Select the LED channel 1 - 12"/> to ' +
            '<select name="' + guid() + '" required class="form-control" ng-model="action.Params.Mode" ng-options="flashRate for flashRate in [\'off\', \'slow\', \'medium\', \'fast\', \'on\']" data-toggle="tooltip" title="Select how the LED should be illuminated">' +
            '  <option ng-value="off">Off</option>' +
            '  <option ng-value="slow">Flash Slow</option>' +
            '  <option ng-value="medium">Flash Medium</option>' +
            '  <option ng-value="fast">Flash Fast</option>' +
            '  <option ng-value="on">On</option>' +
            '</select>';
        return template;
    }
}



class PlayAlarm extends ControlPanel {
    constructor(alarmType, volume, durationInSeconds) {
        super();
        this.Method = 'PlayAlarm';
        this.Params.AlarmType = alarmType;
        this.Params.Volume = volume;
        this.Params.DurationInSeconds = durationInSeconds;
    }

    editTemplate() {
        var template = 'Play <select name="' + guid() + '" required class="form-control" ng-model="action.Params.AlarmType" ng-options="alarmType for alarmType in [\'slow\', \'medium\', \'fast\', \'custom\']" data-toggle="tooltip" title="Select how fast the alarm should pulse">' +
            '</select> Alarm for <input name="' + guid() + '" required class="form-control" type="text" ng-model="action.Params.DurationInSeconds" style="width: 75px" data-toggle="tooltip" title="Specify the number of seconds that the alarm should play for"/> seconds' +
            ' with a volume of <input name="' + guid() + '" required class="form-control" type="text" ng-model="action.Params.Volume" style="width:50px;" data-toggle="tooltip" title="Specify the volume"/>%' +
            '<span ng-show="\'custom\' == action.Params.AlarmType"> and a frequency of <input name="' + guid() + '" required class="form-control" type="text" ng-model="action.Params.Frequency" style="width:50px;"/> (1 - 96) ' +
            ' over a period of <input name="' + guid() + '" required class="form-control" type="text" ng-model="action.Params.Period" style="width:75px;"/> milliseconds</span>';

        // '';
        return template;
    }
}



class SilenceAlarm extends ControlPanel {
    constructor() {
        super();
        this.Method = 'SilenceAlarm';
    }

    editTemplate() {
        var template = 'Silence Alarm';
        return template;
    }
}