/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker.triggers;

import com.integ.janoslib.iolog.IoChannelEvent;
import com.integ.janoslib.iolog.IoChannelLogListener;
import com.integ.tasker.TaskerMain;
import com.integ.tasker.signals.SignalProfile;
import com.integ.tasker.triggers.DeviceSignalDictionary;
import com.integ.tasker.triggers.Trigger;
import com.integpg.janoslib.externalio.ExternalModule;
import java.util.Json;

class DiscreteTrigger
extends Trigger
implements IoChannelLogListener {
    private final SignalProfile _triggerSignalProfile;
    private final ExternalModule _triggerDevice;
    private final String _triggerState;
    private boolean _isTrigger;
    private final String _taskName;

    public DiscreteTrigger(SignalProfile triggerSignalProfile, Json triggerJson, String taskName) {
        this._triggerSignalProfile = triggerSignalProfile;
        System.out.println("triggerJson: " + triggerJson);
        this._triggerDevice = DeviceSignalDictionary.get(this._triggerSignalProfile.DeviceType);
        System.out.println("_triggerDevice: " + this._triggerDevice);
        this._triggerState = triggerJson.getString("State");
        System.out.println("_triggerState: " + this._triggerState);
        this._taskName = taskName;
        if ("din".equalsIgnoreCase(this._triggerSignalProfile.DeviceType)) {
            TaskerMain.DIGITAL_INPUT_MONITOR.addDigitalInputListener(this);
        }
        if ("rout".equalsIgnoreCase(this._triggerSignalProfile.DeviceType)) {
            TaskerMain.DIGITAL_OUTPUT_MONITOR.addDigitalOutputListener(this);
        }
    }

    @Override
    public boolean checkForTrigger() throws Throwable {
        return this._isTrigger;
    }

    public String toString() {
        return " will trigger when " + this._triggerSignalProfile.DeviceType + this._triggerSignalProfile.Channel + " is " + this._triggerState;
    }

    @Override
    public void onIoChannelEvent(IoChannelEvent ioEvent) {
        System.out.println("digitalInput.Channel: " + ioEvent.Channel + ", _triggerSignalProfile.Channel: " + this._triggerSignalProfile.Channel);
        if (ioEvent.Channel == this._triggerSignalProfile.Channel) {
            System.out.println("_triggerState: " + this._triggerState + ", digitalInput.State: " + ioEvent.State);
            if ("high".equalsIgnoreCase(this._triggerState)) {
                this._isTrigger = ioEvent.State;
                if (ioEvent.State) {
                    this.alertListeners();
                }
            } else if ("low".equalsIgnoreCase(this._triggerState)) {
                boolean bl = this._isTrigger = !ioEvent.State;
                if (!ioEvent.State) {
                    this.alertListeners();
                }
            }
        }
    }
}

