/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.janoslib.messagepump;

import com.integpg.janoslib.collections.BlockingQueue;
import com.integpg.janoslib.logging.Logger;
import com.integpg.janoslib.messagepump.MessagePumpListener;
import com.integpg.janoslib.messagepump.SystemMsgTypes;
import com.integpg.system.MessagePump;
import com.integpg.system.SystemMsg;
import java.util.ArrayList;

public class MessagePumpEngine {
    private static boolean PumpOpen = false;
    private static final MessagePump MESSAGE_PUMP = new MessagePump();
    private static final BlockingQueue<SystemMsg> BLOCKING_QUEUE = new BlockingQueue();
    private static final ArrayList<MessagePumpListener> LISTENERS = new ArrayList();
    private static Logger LOG = null;
    private static Thread _messagePumpThread;
    private static Thread _messageNotifierThread;

    private MessagePumpEngine() {
        BLOCKING_QUEUE.setName("MessagePumpEngineQueue");
    }

    public static void setLog(Logger log) {
        LOG = log;
    }

    public static Logger getLog() {
        return LOG;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addListener(MessagePumpListener listener) {
        ArrayList<MessagePumpListener> arrayList = LISTENERS;
        synchronized (arrayList) {
            LISTENERS.add(listener);
        }
        if (!PumpOpen) {
            MessagePumpEngine.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void start() {
        if (PumpOpen) {
            return;
        }
        MessagePump messagePump = MESSAGE_PUMP;
        synchronized (messagePump) {
            if (null == _messagePumpThread) {
                System.out.println("start message pump producer");
                _messagePumpThread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        MessagePumpEngine.openPump();
                        while (true) {
                            SystemMsg systemMsg = MESSAGE_PUMP.getMessage();
                            MESSAGE_PUMP.postMessage(systemMsg);
                            try {
                                BLOCKING_QUEUE.put(systemMsg);
                                continue;
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                                continue;
                            }
                            break;
                        }
                    }
                });
                _messagePumpThread.setName(MessagePumpEngine.class.getName() + ":queue");
                _messagePumpThread.setDaemon(true);
                _messagePumpThread.start();
            }
            if (null == _messageNotifierThread) {
                System.out.println("start message pump consumer");
                _messageNotifierThread = new Thread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        while (true) {
                            try {
                                while (true) {
                                    SystemMsg systemMsg = (SystemMsg)BLOCKING_QUEUE.get();
                                    try {
                                        String messageName = SystemMsgTypes.getMessageNameByType(systemMsg.type);
                                        String contents = "";
                                        if (1024 <= systemMsg.type) {
                                            contents = ": " + new String(systemMsg.msg).trim();
                                        }
                                        if (null != LOG) {
                                            String s = String.format("(%d) %s%s", systemMsg.type, messageName, contents);
                                            LOG.info(s);
                                        }
                                    }
                                    catch (Exception ex) {
                                        ex.printStackTrace();
                                    }
                                    ArrayList arrayList = LISTENERS;
                                    synchronized (arrayList) {
                                        for (MessagePumpListener listener : LISTENERS) {
                                            try {
                                                listener.messageReceived(systemMsg);
                                            }
                                            catch (Throwable ex) {
                                                ex.printStackTrace();
                                            }
                                        }
                                    }
                                    Thread.sleep(1L);
                                }
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                                continue;
                            }
                            break;
                        }
                    }
                });
                _messageNotifierThread.setName(MessagePumpEngine.class.getName() + ":notifier");
                _messageNotifierThread.setDaemon(true);
                _messageNotifierThread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void postMessage(SystemMsg msg) {
        MessagePump messagePump = MESSAGE_PUMP;
        synchronized (messagePump) {
            if (!PumpOpen) {
                MessagePumpEngine.start();
            }
            MESSAGE_PUMP.postMessage(msg);
        }
    }

    private static void openPump() {
        System.out.println("open the message pump and start monitoring.\r\n");
        MESSAGE_PUMP.open();
        PumpOpen = true;
    }
}

