/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker.triggers;

import com.integ.tasker.triggers.Reset;
import com.integ.tasker.triggers.Trigger;
import com.integ.tasker.triggers.TriggersConfiguration;
import com.integ.tasker.workspaces.WorkspaceFile;
import java.util.ArrayList;

public class TriggerMonitor
implements Runnable {
    private static final int TRIGGER_SLEEP = 200;
    private final WorkspaceFile _workspaceConfigurationFile;
    private final ArrayList<Trigger> _triggerCollection = new ArrayList();
    private final ArrayList<Reset> _resetCollection = new ArrayList();
    private Thread _thread;
    private boolean _stopped;

    public TriggerMonitor(WorkspaceFile workspaceConfigurationFile) {
        this._workspaceConfigurationFile = workspaceConfigurationFile;
    }

    public void addTrigger(Trigger trigger) {
        this._triggerCollection.add(trigger);
        System.out.println(String.format("%d triggers in collection", this._triggerCollection.size()));
    }

    public void addReset(Reset reset) {
        this._resetCollection.add(reset);
        System.out.println(String.format("%d resets in collection", this._resetCollection.size()));
    }

    public void start() {
        if (null == this._thread) {
            TriggersConfiguration.LOG.info("starting trigger monitor for " + this._workspaceConfigurationFile.getName());
            this._stopped = false;
            this._thread = new Thread(this);
            this._thread.setDaemon(true);
            this._thread.setName(this.getClass().getName() + ":" + this._workspaceConfigurationFile.getName());
            this._thread.start();
        }
    }

    public void stop() {
        try {
            if (null != this._thread) {
                TriggersConfiguration.LOG.info("Stopping " + this._workspaceConfigurationFile.getName());
                this._stopped = true;
                this._thread.interrupt();
                this._thread.join();
            }
        }
        catch (Exception ex) {
            TriggersConfiguration.LOG.error("error stopping trigger monitor for " + this._workspaceConfigurationFile.getName(), ex);
        }
    }

    @Override
    public void run() {
        TriggersConfiguration.LOG.info(Thread.currentThread().getName() + " trigger started.");
        while (!this._stopped) {
            try {
                this.checkTriggers();
                this.checkResets();
                Thread.sleep(200L);
            }
            catch (InterruptedException ex) {
                System.out.println(Thread.currentThread().getName() + " interrupted");
                break;
            }
        }
        TriggersConfiguration.LOG.info("trigger monitor for " + this._workspaceConfigurationFile.getName() + " done.");
        this._thread = null;
    }

    private void checkTriggers() {
        int triggersSize = this._triggerCollection.size();
        for (int i = 0; i < triggersSize; ++i) {
            Trigger trigger = this._triggerCollection.get(i);
            try {
                trigger.checkForTrigger();
                continue;
            }
            catch (Throwable ex) {
                TriggersConfiguration.LOG.error(new Exception("error checking trigger " + trigger.getName(), ex));
            }
        }
    }

    private void checkResets() {
        int resetsSize = this._resetCollection.size();
        for (int i = 0; i < resetsSize; ++i) {
            Reset reset = this._resetCollection.get(i);
            try {
                reset.checkForReset();
                continue;
            }
            catch (Throwable ex) {
                TriggersConfiguration.LOG.error(new Exception("error checking reset " + reset.getTrigger().getName(), ex));
            }
        }
    }

    public void clear() {
        this._triggerCollection.clear();
        this._resetCollection.clear();
    }
}

