/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker.tasks.actions.network;

import com.integ.tasker.TextReplacer;
import com.integ.tasker.tasks.Task;
import com.integ.tasker.tasks.TaskRuntime;
import com.integ.tasker.tasks.actions.Action;
import com.integpg.janoslib.utils.StringUtils;
import com.integpg.system.JANOS;
import com.integpg.system.MailComposer;
import java.util.Json;

public class EmailProfileSendMethod
extends Action {
    public EmailProfileSendMethod(Task parentTask, Json json) throws Throwable {
        super(parentTask, json);
    }

    @Override
    public void execute(TaskRuntime taskRuntime) throws Throwable {
        try {
            String emailProfileName = super.getStringParam("ProfileName", taskRuntime);
            emailProfileName = StringUtils.trim(emailProfileName, '\"');
            System.out.println("EmailProfile command: " + emailProfileName);
            String[] toAddresses = JANOS.getRegistryKey((String)("Email/" + emailProfileName + "/ToAddress"));
            String[] toCcAddresses = JANOS.getRegistryKey((String)("Email/" + emailProfileName + "/CcAddress"));
            String[] toBccAddresses = JANOS.getRegistryKey((String)("Email/" + emailProfileName + "/BccAddress"));
            String subject = JANOS.getRegistryString((String)("Email/" + emailProfileName + "/Subject"), (String)"");
            System.out.println("subject: " + subject);
            subject = TextReplacer.replace(subject, taskRuntime.Scope);
            System.out.println("subject: " + subject);
            String message = JANOS.getRegistryString((String)("Email/" + emailProfileName + "/Message"), (String)"");
            System.out.println("message: " + message);
            message = TextReplacer.replace(message, taskRuntime.Scope);
            System.out.println("message: " + message);
            MailComposer mailComposer = new MailComposer();
            mailComposer.setToAddress(toAddresses);
            mailComposer.setCcAddress(toCcAddresses);
            mailComposer.setBccAddress(toBccAddresses);
            mailComposer.setSubject(subject);
            mailComposer.setMessage(message);
            mailComposer.send();
        }
        catch (Exception ex) {
            throw new Exception("Error executing Email Profile Send").initCause(ex);
        }
    }
}

