function parseRelayControlAction(json) {
    var method = json.Method;

    switch (method) {
        case 'CloseRelay':
            return new CloseRelay();

        case 'OpenRelay':
            return new OpenRelay();

        case 'ToggleRelay':
            return new ToggleRelay();

        case 'SetRelayState':
            return new SetRelayState();

        case 'PulseRelay':
            return new PulseRelay();

        case 'SetBlock':
            return new SetBlock();

        case 'PulseBlock':
            return new PulseBlock();

        case 'RoutResetUsageMeter':
            return new RoutResetUsageMeter();

        default:
            throw new Error('Unknown Action Method: ' + JSON.stringify(json, null, 2));
    }
}



class RelayControl extends Action {
    constructor() {
        super();
        this.Type = 'RelayControl';
        this.Method = 'void';
        this.Params = {};
    }
}


class CloseRelay extends RelayControl {
    constructor(channel) {
        super();
        this.Method = 'CloseRelay';
        this.Params.Channel = channel || 1;
    }

    editTemplate() {
        var template = 'Close Relay ' +
            '<input name="' + guid() + '" class="form-control" type="text" ng-model="action.Params.Channel"' +
            ' data-toggle="tooltip" title="Output Channel (1 - 16)" style="width: 100px;" required />';
        return template;
    }
}



class OpenRelay extends RelayControl {
    constructor(channel) {
        super();
        this.Method = 'OpenRelay';
        this.Params.Channel = channel || 1;
    }

    editTemplate() {
        var template = 'Open Relay ' +
            '<input name="' + guid() + '" class="form-control" type="text" ng-model="action.Params.Channel"' +
            ' data-toggle="tooltip" title="Output Channel (1 - 16)" style="width: 100px;" required />';
        return template;
    }
}



class ToggleRelay extends RelayControl {
    constructor(channel) {
        super();
        this.Method = 'ToggleRelay';
        this.Params.Channel = channel || 1;
    }

    editTemplate() {
        var template = 'Toggle Relay ' +
            '<input name="' + guid() + '" class="form-control" type="text" ng-model="action.Params.Channel"' +
            ' data-toggle="tooltip" title="Toggle Channel (1 - 16)" style="width: 100px;" required />';
        return template;
    }
}



class SetRelayState extends RelayControl {
    constructor(channel, state) {
        super();
        this.Method = 'SetRelayState';
        this.Params.Channel = channel || 1;
        this.Params.State = state;
    }

    editTemplate() {
        var template = 'Set Relay ' +
            '<input name="' + guid() + '" required class="form-control" type="text" ng-model="action.Params.Channel"' +
            ' data-toggle="tooltip" title="Output Channel (1 - 16)" style="width: 100px;" /> to ' +
            '<select name="' + guid() + '" required class="form-control"' +
            ' data-toggle="tooltip" title="The desired new state of the output"' +
            ' ng-model="action.Params.State" ng-options="state for state in [\'HIGH\', \'LOW\', \'Variable\']"></select> ' +
            '<input name="' + guid() + '" class="form-control hidden" type="text" ng-show="action.Params.State.toLower() == \"variable\".trim()"' +
            ' ng-model="action.Params.VariableName" data-toggle="tooltip" title="Variable Name" style="width: 100px;" />';
        return template;
    }
}



class PulseRelay extends RelayControl {
    constructor(channel, duration, timingUnits) {
        super();
        this.Method = 'PulseRelay';
        this.Params.Channel = channel || 1;
        this.Params.State = "HIGH";
        this.Params.Duration = duration || 1;
        // this.Params.TimingUnits = timingUnits || 'seconds';
    }

    editTemplate() {
        var template = 'Pulse Relay ' +
            '<input name="' + guid() + '" class="form-control" type="text" ng-model="action.Params.Channel"' +
            ' data-toggle="tooltip" title="Output Channel (1 - 16)" style="width: 100px;" required /> \r\n' +
            ' for ' +
            '<input name="' + guid() + '" required class="form-control" type="text" ng-model="action.Params.Duration"' +
            ' data-toggle="tooltip" title="Length of pulse in seconds.  Seconds can be represented with a decimal point and do not need to be whole seconds." style="width: 100px;" /> seconds'; //\r\n' +
        return template;
    }
}



class SetBlock extends RelayControl {
    constructor(channelMask, stateMask) {
        super();
        this.Method = 'SetBlock';
        this.Params.ChannelMask = channelMask || 0;
        this.Params.StateMask = stateMask || 0;
    }

    editTemplate() {
        var template = 'Set Relays ' +
            '<input name="' + guid() + '" required class="form-control" type="text" ng-model="action.Params.ChannelMask" data-toggle="tooltip" title="A binary representation of the channels that should be affected by this command and set to the states defined in the states mask.  (0 - 65535)" style="width:100px;" /> \r\n' +
            ' to <input name="' + guid() + '" required class="form-control" type="text" ng-model="action.Params.StateMask" data-toggle="tooltip" title="A binary representation of the states that should be asigned to the outputs defined in the channel mask.  (0 - 65535)" style="width:100px;" /> \r\n';
        return template;
    }
}



class PulseBlock extends RelayControl {
    constructor(channelMask, stateMask, duration, timingUnits) {
        super();
        this.Method = 'PulseBlock';
        this.Params.ChannelMask = channelMask || 0;
        this.Params.StateMask = stateMask || 0;
        this.Params.Duration = duration || 1;
        // this.Params.TimingUnits = timingUnits || 'seconds';
    }

    editTemplate() {
        var template = 'Pulse Relays ' +
            '<input name="' + guid() + '" required class="form-control" type="text" ng-model="action.Params.ChannelMask" data-toggle="tooltip" title="A binary representation of the channels that should be affected by this command and set to the states defined in the states mask.  (0 - 65535)" style="width:100px;" /> \r\n' +
            ' to <input name="' + guid() + '" required class="form-control" type="text" ng-model="action.Params.StateMask" data-toggle="tooltip" title="A binary representation of the states that should be asigned to the outputs defined in the channel mask.  (0 - 65535)" style="width:100px;" /> \r\n' +
            ' for <input name="' + guid() + '" required class="form-control" type="text" ng-model="action.Params.Duration" data-toggle="tooltip" title="Length of pulse in seconds" style="width: 100px;" /> seconds';
        // '<select ng-model="action.Params.TimingUnits" class="form-control" ng-options="unit for unit in [\'milliseconds\', \'seconds\', \'minutes\']">\r\n' +
        // '  <option>milliseconds</option>\r\n' +
        // '  <option>seconds</option>\r\n' +
        // '  <option>minutes</option>\r\n' +
        // '</select>';
        return template;
    }
}



class RoutResetUsageMeter extends RelayControl {
    constructor() {
        super();
        this.Method = 'RoutResetUsageMeter';
    }

    editTemplate() {
        var template = 'Reset Usage Meter for Relay Output ' +
            '<input name="' + guid() + '" class="form-control" type="text" ng-model="action.Params.Channel"' +
            ' data-toggle="tooltip" title="Digital Input (1 - 12)" style="width: 100px;" required />';
        return template;
    }
}