/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker.identifierobjects;

import com.integ.janoslib.externalmodules.ExternalDeviceMap;
import com.integ.tasker.identifierobjects.DateObject;
import com.integ.tasker.identifierobjects.DinDeviceObject;
import com.integ.tasker.identifierobjects.EnvironSensorObject;
import com.integ.tasker.identifierobjects.RegistryObject;
import com.integ.tasker.identifierobjects.RoutDeviceObject;
import com.integ.tasker.identifierobjects.TempProbeObject;
import com.integ.tasker.identifierobjects.TimeObject;

public abstract class IdentifierObject {
    protected final String _identifierName;
    protected int _channel = -1;
    protected String _fieldName;
    protected String _methodName;
    protected String _parametersString;

    public static IdentifierObject getIdentifierObject(String identifierNameString) {
        if ("din".equalsIgnoreCase(identifierNameString = identifierNameString.toLowerCase())) {
            return new DinDeviceObject(identifierNameString);
        }
        if ("rout".equalsIgnoreCase(identifierNameString)) {
            return new RoutDeviceObject(identifierNameString);
        }
        if ("temp".equalsIgnoreCase(identifierNameString)) {
            return new TempProbeObject(identifierNameString);
        }
        if ("env".equalsIgnoreCase(identifierNameString)) {
            return new EnvironSensorObject(identifierNameString);
        }
        if ("registry".equalsIgnoreCase(identifierNameString) || "reg".equalsIgnoreCase(identifierNameString)) {
            return new RegistryObject(identifierNameString);
        }
        if ("date".equalsIgnoreCase(identifierNameString)) {
            return new DateObject(identifierNameString);
        }
        if ("time".equalsIgnoreCase(identifierNameString)) {
            return new TimeObject(identifierNameString);
        }
        return null;
    }

    protected IdentifierObject(String identifierName) {
        this._identifierName = identifierName;
    }

    public void setChannel(int channel) {
        this._channel = channel;
    }

    public void setField(String fieldName) {
        this._fieldName = fieldName.toLowerCase();
    }

    public void setMethod(String methodName, String parameterString) {
        this._methodName = methodName;
        this._parametersString = parameterString;
    }

    public abstract Object evaluate();

    public String toString() {
        return this._identifierName + " : " + this._methodName + " : " + this._channel + " : " + this._fieldName;
    }

    static {
        ExternalDeviceMap.start();
    }
}

