/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.janoslib.externalio;

import com.integpg.janoslib.text.QuickDateFormat;
import com.integpg.janoslib.utils.ExternalUtils;
import com.integpg.sensor.SensorPort;
import com.integpg.system.ArrayUtils;
import java.io.IOException;
import java.util.Hashtable;

public abstract class ExternalModule {
    protected static final Hashtable<String, ExternalModule> CACHED_DEVICES = new Hashtable();
    protected static final SensorPort SENSOR_PORT = new SensorPort();
    protected static QuickDateFormat QUICK_DATE_FORMAT = new QuickDateFormat("yyyy-MM-dd HH:mm:ss zzz");
    public long Address;
    public String AddressString;
    public int TypeIndex;
    public String TypeString;
    public long LastReadTime;
    public long LastWriteTime;
    protected byte[] _dataBlock;
    protected byte[] _savedDataBlock;
    protected final byte[] _outBytes = new byte[8];
    protected boolean _hasChanged = false;
    protected static String[] _externalDevices;
    protected boolean _dirty = false;

    protected ExternalModule(long address, int number, String typeString) {
        this.setAddress(address);
        if (0 > number) {
            number = ExternalUtils.getIndexForAddress(this.AddressString);
            System.out.println(this.AddressString + " index is now " + number);
        }
        this.TypeIndex = number;
        this.TypeString = typeString + "_" + number;
    }

    private void setAddress(long address) {
        this.Address = address;
        this.AddressString = "0000000000000000" + Long.toHexString(address);
        this.AddressString = this.AddressString.substring(this.AddressString.length() - 16);
        this.AddressString = this.AddressString.toUpperCase();
    }

    public boolean isDirty() {
        return this._dirty;
    }

    public long getMinReadInterval() {
        return 0L;
    }

    protected boolean checkForChange() {
        boolean hasChanged = false;
        if (null == this._savedDataBlock || this._dataBlock.length != this._savedDataBlock.length) {
            this._savedDataBlock = new byte[this._dataBlock.length];
            hasChanged = true;
        }
        if (!ArrayUtils.arrayComp((Object)this._dataBlock, (int)0, (Object)this._savedDataBlock, (int)0, (int)this._dataBlock.length)) {
            ArrayUtils.arraycopy((Object)this._dataBlock, (int)0, (Object)this._savedDataBlock, (int)0, (int)this._dataBlock.length);
            hasChanged = true;
        }
        this._hasChanged = hasChanged;
        return this._hasChanged;
    }

    public boolean hasChanged() {
        return this._hasChanged;
    }

    public abstract void read() throws Throwable;

    public abstract void commit() throws IOException;

    public byte[] getDataBlock() {
        return this._dataBlock;
    }

    public byte[] getWriteBlock() {
        return this._outBytes;
    }

    public abstract void printValues();

    public float getPercent(int raw) {
        return (float)((double)raw / 65535.0);
    }

    public float scaleValue(int raw, double min, double max) {
        double percent = (double)raw / 65535.0;
        return (float)(percent * (max - min) + min);
    }

    public abstract Object get(String var1);

    public boolean isPresent() {
        return ExternalUtils.isPresent(this.AddressString);
    }

    public String toString() {
        return String.format("%s: %s  %s", this.TypeString, this.AddressString, this.isPresent() ? "present" : "not present");
    }
}

