/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker.tasks.actions.analog;

import com.integ.scripting.ExpressionEngine;
import com.integ.tasker.tasks.Task;
import com.integ.tasker.tasks.TaskRuntime;
import com.integ.tasker.tasks.actions.Action;
import com.integpg.janoslib.externalio.TypeFD;
import com.integpg.janoslib.logging.AppLog;
import java.util.Json;

public class Fade10vPercentageMethod
extends Action {
    private final ExpressionEngine _expressionEngine = new ExpressionEngine();

    public Fade10vPercentageMethod(Task parentTask, Json json) {
        super(parentTask, json);
    }

    @Override
    public void execute(TaskRuntime taskRuntime) throws Throwable {
        boolean _debug_ = taskRuntime.Scope.isDebug();
        try {
            TypeFD typeFd;
            int channel = this.getIntParam("Channel", taskRuntime);
            String percentString = this._paramsJson.getString("Percent");
            double durationSeconds = this._paramsJson.getDouble("Duration");
            int duration = (int)durationSeconds * 1000;
            if (_debug_) {
                System.out.println(String.format("channel: %d, percent: %s, durationSeconds: %f", channel, percentString, durationSeconds));
            }
            this._expressionEngine.setDebug(_debug_);
            this._expressionEngine.parse(percentString);
            Object resultObject = this._expressionEngine.execute(taskRuntime.Scope);
            if (_debug_) {
                System.out.println(percentString + " = " + resultObject);
            }
            double percent = Double.valueOf(resultObject.toString());
            System.out.println(String.format("channel: %d, voltage: %f", channel, percent));
            int index = (channel - 1) / 2;
            if (_debug_) {
                System.out.println("index: " + index);
            }
            if (null != (typeFd = TypeFD.getByIndex(index))) {
                int localChannel = (channel - 1) % 2;
                if (_debug_) {
                    System.out.println("localChannel: " + localChannel);
                }
                typeFd.fadeChannelPercentage(localChannel, percent, duration);
                typeFd.commit();
            }
        }
        catch (Exception ex) {
            AppLog.error(new Exception("Error fading 10v channel percentage", ex));
        }
    }
}

