/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker.identifierobjects;

import com.integ.tasker.identifierobjects.IdentifierObject;
import com.integpg.janoslib.datastructures.Queue;
import com.integpg.janoslib.io.AppLog;
import com.integpg.janoslib.lexer.Lexer;
import com.integpg.janoslib.lexer.Token;
import com.integpg.janoslib.lexer.TokenStream;
import com.integpg.janoslib.utils.StringUtils;
import java.util.ArrayList;

public class Identifier {
    private final String _identifierString;

    public Identifier(String identifierString) {
        this._identifierString = identifierString;
    }

    public Object evaluate() {
        System.out.println("Identifier.evaluate(): " + this._identifierString);
        long start = System.currentTimeMillis();
        Object result = null;
        try {
            Queue<Token> tokenQueue = new Queue<Token>();
            Lexer.parse(tokenQueue, this._identifierString);
            TokenStream tokens = new TokenStream(tokenQueue);
            tokens.printDebug(true);
            Token currentToken = tokens.getCurrent();
            if (0 != currentToken.type) {
                throw new RuntimeException("device identifier expected.  found " + currentToken + " instead");
            }
            String identifierNameString = currentToken.content;
            System.out.println("identifierNameString: " + identifierNameString);
            IdentifierObject identifierObject = IdentifierObject.getIdentifierObject(identifierNameString);
            if (null == identifierObject) {
                throw new RuntimeException("unknown identifier object for " + identifierNameString);
            }
            currentToken = tokens.nextToken();
            if (91 == currentToken.type) {
                currentToken = tokens.nextToken();
                if (3 != currentToken.type) {
                    throw new RuntimeException("channel expected.  found " + currentToken + " instead");
                }
                int channel = Integer.parseInt(currentToken.content);
                identifierObject.setChannel(channel);
                System.out.println("channel: " + channel);
                currentToken = tokens.nextToken();
                if (93 != currentToken.type) {
                    throw new RuntimeException("']' expected.  found " + currentToken + " instead");
                }
                currentToken = tokens.nextToken();
            }
            String fieldOrMethod = "";
            if (46 == currentToken.type) {
                currentToken = tokens.nextToken();
                fieldOrMethod = currentToken.content;
                if (!tokens.isEmpty()) {
                    currentToken = tokens.nextToken();
                }
            }
            if (!tokens.isEmpty()) {
                if (40 == currentToken.type) {
                    System.out.println("parens: " + currentToken);
                    currentToken = tokens.nextToken();
                    Object[] paramsArray = new String[]{};
                    if (!currentToken.checkType(41)) {
                        ArrayList<String> paramsList = new ArrayList<String>();
                        while (!currentToken.checkType(41)) {
                            System.out.println("  param arg: " + currentToken);
                            paramsList.add(currentToken.content);
                            currentToken = tokens.nextToken();
                        }
                        System.out.println("params: " + StringUtils.join(paramsList.toArray(), ",  "));
                        paramsArray = (String[])paramsList.toArray();
                    }
                    identifierObject.setMethod(fieldOrMethod, paramsArray);
                } else {
                    identifierObject.setField(fieldOrMethod);
                }
            } else {
                identifierObject.setField(fieldOrMethod);
            }
            result = identifierObject.evaluate();
        }
        catch (Exception ex) {
            AppLog.error("error processing idenitifer", ex);
        }
        long elapsed = System.currentTimeMillis() - start;
        System.out.println("Identifier.evaluate() elapsed2: " + elapsed);
        return result;
    }

    public String toString() {
        return this.getClass() + ":" + this._identifierString;
    }
}

