/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker.tasks.actions.controlstructures;

import com.integ.tasker.tasks.Task;
import com.integ.tasker.tasks.TaskRuntime;
import com.integ.tasker.tasks.actions.Action;
import com.integpg.tasker.TextReplacer;
import com.integpg.tasker.ast.ASTNode;
import com.integpg.tasker.ast.ASTParser;
import java.util.Json;

public class SetVariableMethod
extends Action {
    private final String _variable;
    private final String _conditional;

    public SetVariableMethod(Task parentTask, Json json) {
        super(parentTask, json);
        this._variable = this._paramsJson.getString("Variable");
        System.out.println("Variable: " + this._variable);
        this._conditional = this._paramsJson.getString("Conditional");
        System.out.println("conditional: " + this._conditional);
    }

    @Override
    public void execute(TaskRuntime taskRuntime) throws Throwable {
        long start = System.currentTimeMillis();
        try {
            String newConditionalString = TextReplacer.replace(this._conditional, taskRuntime.Scope);
            System.out.println(String.format("newConditionalString: %s", newConditionalString));
            ASTParser expressionParser = new ASTParser(newConditionalString, null);
            ASTNode expressionNode = expressionParser.parse();
            System.out.println("expressionNode: " + expressionNode + "(" + expressionNode.getClass().getName() + ")");
            Object resultObject = expressionNode.evaluate();
            System.out.println("resultObject: " + resultObject + "(" + resultObject.getClass().getName() + ")");
            taskRuntime.Scope.setVariable(this._variable, resultObject);
        }
        catch (Exception ex) {
            throw new Exception("Error Setting Variable: " + this._variable + " to " + this._conditional).initCause(ex);
        }
        long elapsed = System.currentTimeMillis() - start;
        System.out.println("set variable elapsed: " + elapsed);
    }
}

