/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker.schedules;

import com.integ.tasker.AssemblyInfo;
import com.integ.tasker.Unloadable;
import com.integ.tasker.schedules.ScheduleCollection;
import com.integ.tasker.schedules.rules.OnBootRule;
import com.integ.tasker.schedules.rules.ScheduleRuleBase;
import com.integ.tasker.schedules.rules.ScheduleRuleFactory;
import com.integ.tasker.tasks.Task;
import com.integ.tasker.tasks.TaskCollection;
import com.integ.tasker.tasks.TaskResult;
import com.integ.tasker.web.messages.ErrorMessage;
import com.integ.tasker.workspaces.WorkspaceFile;
import com.integpg.janoslib.logging.AppLog;
import com.integpg.janoslib.logging.Logger;
import com.integpg.janoslib.messagepump.MessagePumpEngine;
import com.integpg.janoslib.system.AssemblyInfoBase;
import com.integpg.janoslib.threading.ThreadPool;
import java.util.ArrayList;
import java.util.Json;

public class Schedule
implements Unloadable,
Runnable {
    public static final Logger LOG;
    private final Json _json;
    private final WorkspaceFile _parentWorkspaceFile;
    private Json _paramsJson;
    public String Name;
    public String GUID;
    public String TaskName;
    private ArrayList<ScheduleRuleBase> _scheduleRules = new ArrayList();
    private boolean _isUnloaded = false;

    public Schedule(Json json, WorkspaceFile parentWorkspaceFile) {
        this._json = json;
        this._parentWorkspaceFile = parentWorkspaceFile;
        try {
            LOG.info("loading Schedule from " + json);
            this.Name = json.getString("Name");
            this.GUID = json.getString("GUID");
            this._paramsJson = (Json)this._json.get("Params");
            boolean enabled = this._paramsJson.getBoolean("Enabled");
            if (!enabled) {
                LOG.info(String.format("%s (%s) is not enabled", this.Name, this.GUID));
                return;
            }
            this.TaskName = this._paramsJson.getString("TaskName");
            LOG.info(String.format("schedule %s (%s) will execute %s", this.Name, this.GUID, this.TaskName));
            this.loadRules();
            parentWorkspaceFile.addUnloadable(this);
        }
        catch (Throwable ex) {
            Throwable throwable = new Exception("unable to load " + this.Name).initCause(ex);
            LOG.error(throwable);
            ErrorMessage message = new ErrorMessage(throwable);
            MessagePumpEngine.postMessage(message.build());
        }
    }

    @Override
    public void unload() {
        this._isUnloaded = true;
        ScheduleCollection.remove(this);
    }

    public boolean isEnabled() {
        boolean enabled = this._paramsJson.getBoolean("Enabled");
        return enabled;
    }

    @Override
    public void run() {
        try {
            Task task = TaskCollection.GLOBAL.getByTaskName(this.TaskName);
            if (null != task) {
                TaskResult result = task.execute(String.format("Schedule: %s", this.Name));
            }
        }
        catch (Throwable ex) {
            AppLog.error(ex);
            ErrorMessage message = new ErrorMessage(ex);
            MessagePumpEngine.postMessage(message.build());
        }
    }

    private void loadRules() {
        Json[] rulesJsonArray = (Json[])this._paramsJson.get("Rules");
        if (null != rulesJsonArray) {
            for (Json ruleJson : rulesJsonArray) {
                System.out.println("ruleJson: " + ruleJson);
                ScheduleRuleBase scheduleBase = ScheduleRuleFactory.getRule(this, ruleJson);
                System.out.println("scheduleBase = " + scheduleBase);
                if (scheduleBase instanceof OnBootRule && this._parentWorkspaceFile.wasLoadedOnBoot()) {
                    this.execute();
                    continue;
                }
                this._scheduleRules.add(scheduleBase);
            }
        }
    }

    public ArrayList<ScheduleRuleBase> getScheduleRules() {
        return this._scheduleRules;
    }

    public void execute() {
        String description = String.format("%s execute %s", this.Name, this.TaskName);
        LOG.info(description);
        ThreadPool.execute(this);
    }

    boolean isUnloaded() {
        return this._isUnloaded;
    }

    WorkspaceFile getWorkspaceFile() {
        return this._parentWorkspaceFile;
    }

    static {
        StringBuilder stringBuilder = new StringBuilder();
        AssemblyInfo.getInstance();
        LOG = Logger.getLogger(stringBuilder.append(AssemblyInfoBase.getName()).append("_schedules.log").toString());
    }
}

