/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker.triggers;

import com.integ.tasker.WorkspaceConfigurationFile;
import com.integ.tasker.triggers.Reset;
import com.integ.tasker.triggers.Trigger;
import com.integ.tasker.triggers.TriggersConfiguration;
import java.util.ArrayList;

public class TriggerMonitor
implements Runnable {
    private final WorkspaceConfigurationFile _workspaceConfigurationFile;
    private final ArrayList<Trigger> _triggerCollection = new ArrayList();
    private final ArrayList<Reset> _resetCollection = new ArrayList();
    private Thread _thread;
    private boolean _stopped;

    public TriggerMonitor(WorkspaceConfigurationFile workspaceConfigurationFile) {
        this._workspaceConfigurationFile = workspaceConfigurationFile;
    }

    public void addTrigger(Trigger trigger) {
        this._triggerCollection.add(trigger);
        System.out.println(String.format("%d triggers in collection", this._triggerCollection.size()));
    }

    public void addReset(Reset reset) {
        this._resetCollection.add(reset);
        System.out.println(String.format("%d resets in collection", this._resetCollection.size()));
    }

    public void start() {
        if (null == this._thread) {
            this._thread = new Thread(this);
            this._thread.setDaemon(true);
            this._thread.setName(this.getClass().getName() + ":" + this._workspaceConfigurationFile.getName());
            this._thread.start();
        }
    }

    void stop() {
        try {
            TriggersConfiguration.LOG.info("Stopping " + this._workspaceConfigurationFile.getName());
            this._stopped = true;
            this._thread.interrupt();
            this._thread.join();
        }
        catch (Exception e) {
            System.out.println("Exception handled: " + e.getMessage());
        }
    }

    @Override
    public void run() {
        TriggersConfiguration.LOG.info(Thread.currentThread().getName() + " trigger started.");
        while (!this._stopped) {
            try {
                this.checkTriggers();
                this.checkResets();
                Thread.sleep(200L);
            }
            catch (InterruptedException ex) {
                System.out.println(Thread.currentThread().getName() + " interrupted");
                break;
            }
        }
        TriggersConfiguration.LOG.info(this._workspaceConfigurationFile.getName() + " done.");
        this._thread = null;
    }

    private void checkTriggers() {
        for (Trigger trigger : this._triggerCollection) {
            try {
                trigger.checkForTrigger();
            }
            catch (Throwable ex) {
                TriggersConfiguration.LOG.error(new Exception("error checking " + trigger.getName(), ex));
            }
        }
    }

    private void checkResets() {
        for (Reset reset : this._resetCollection) {
            try {
                reset.checkForReset();
            }
            catch (Throwable ex) {
                TriggersConfiguration.LOG.error(new Exception("error checking " + reset.getTrigger().getName(), ex));
            }
        }
    }
}

