/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker.triggers.triggertypes;

import com.integ.janoslib.iolog.IoChannelEvent;
import com.integ.janoslib.iolog.IoChannelLogListener;
import com.integ.tasker.TaskerMain;
import com.integ.tasker.Unloadable;
import com.integ.tasker.WorkspaceConfigurationFile;
import com.integ.tasker.signals.SignalProfile;
import com.integ.tasker.signals.SignalProfilesCollection;
import com.integ.tasker.triggers.Trigger;
import java.util.Json;

public class DiscreteSignalTrigger
extends Trigger
implements IoChannelLogListener,
Unloadable {
    private final Json _paramsJson;
    private final String _signalProfileName;
    private final String _triggerState;
    private SignalProfile _signalProfile;

    public DiscreteSignalTrigger(Json triggerJson) {
        this._paramsJson = (Json)triggerJson.get("Params");
        System.out.println("DiscreteSignalTrigger.paramsJson: " + this._paramsJson);
        this._triggerState = this._paramsJson.getString("State");
        System.out.println("_triggerState: " + this._triggerState);
        Json triggerSignalJson = (Json)this._paramsJson.get("Signal");
        System.out.println("_triggerSignalJson: " + triggerSignalJson);
        this._signalProfileName = triggerSignalJson.getString("Name");
    }

    @Override
    public void setWorkspaceConfigurationFile(WorkspaceConfigurationFile workspaceConfigurationFile) {
        super.setWorkspaceConfigurationFile(workspaceConfigurationFile);
        this._workspaceConfigurationFile.addUnloadable(this);
        System.out.println("DiscreteSignalTrigger._signalProfileName: " + this._signalProfileName);
        SignalProfilesCollection signalProfilesCollection = workspaceConfigurationFile.getSignalProfilesCollection();
        if (signalProfilesCollection.containsSignalProfileName(this._signalProfileName)) {
            this._signalProfile = signalProfilesCollection.getByName(this._signalProfileName);
        }
        System.out.println("_signalProfile.DeviceType: " + this._signalProfile.DeviceType);
        if ("din".equalsIgnoreCase(this._signalProfile.DeviceType)) {
            TaskerMain.DIGITAL_INPUT_MONITOR.addDigitalInputListener(this);
        } else if ("rout".equalsIgnoreCase(this._signalProfile.DeviceType)) {
            TaskerMain.DIGITAL_OUTPUT_MONITOR.addDigitalOutputListener(this);
        }
    }

    @Override
    public void unload() {
        System.out.println("_signalProfile.DeviceType: " + this._signalProfile.DeviceType);
        if ("din".equalsIgnoreCase(this._signalProfile.DeviceType)) {
            TaskerMain.DIGITAL_INPUT_MONITOR.removeDigitalInputListener(this);
        } else if ("rout".equalsIgnoreCase(this._signalProfile.DeviceType)) {
            TaskerMain.DIGITAL_OUTPUT_MONITOR.removeDigitalOutputListener(this);
        }
    }

    @Override
    public void onIoChannelEvent(IoChannelEvent ioEvent) {
        System.out.println("discrete trigger " + this.toString());
        System.out.println("Channel: " + ioEvent.Channel + ", _triggerSignalProfile.Channel: " + this._signalProfile.Channel);
        if (ioEvent.Channel == this._signalProfile.Channel) {
            System.out.println("_triggerState: " + this._triggerState + ", ioEvent.State: " + ioEvent.State);
            if ("either".equalsIgnoreCase(this._triggerState)) {
                this.trigger();
            } else if (ioEvent.State && "high".equalsIgnoreCase(this._triggerState)) {
                this.trigger();
            } else if (!ioEvent.State && "low".equalsIgnoreCase(this._triggerState)) {
                this.trigger();
            }
        }
    }
}

