/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.janoslib.logger;

import com.integpg.janoslib.logger.FileLog;
import com.integpg.janoslib.logger.LogOptions;
import com.integpg.janoslib.logger.LogOutputStream;
import com.integpg.janoslib.utils.FileUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Date;

public class HalfBakLogOutputStream
extends LogOutputStream {
    public HalfBakLogOutputStream(LogOptions logOptions) throws FileNotFoundException {
        super(logOptions);
    }

    @Override
    protected int preWrite(byte[] b, int off, int len) throws IOException {
        return 0;
    }

    @Override
    protected void postWrite(int len) throws IOException {
        if ((long)this._logOptions.getMaxFileSize() < this._file.length()) {
            this.halfBakFile();
        }
    }

    private void halfBakFile() throws IOException {
        long start = System.currentTimeMillis();
        System.out.println("file size: " + this._file.length());
        int halfSize = this._logOptions.getMaxFileSize() / 2;
        byte[] firstHalf = FileUtils.readBytes(this._logOptions.getFilePath(), 0, halfSize);
        Date lastEntryDate = null;
        block2: for (int i = firstHalf.length - 1; i >= 0; --i) {
            if (10 != firstHalf[i]) continue;
            halfSize = i;
            System.out.println("half size: " + halfSize);
            int lastComma = -1;
            for (int j = i - 1; j >= 0; --j) {
                if (44 == firstHalf[j]) {
                    lastComma = j;
                    continue;
                }
                if (10 != firstHalf[j] || -1 == lastComma) continue;
                String dateString = new String(firstHalf, ++j, lastComma - j);
                try {
                    lastEntryDate = FileLog.LogDateFormat.parse(dateString);
                }
                catch (Exception ex) {
                    lastEntryDate = new Date();
                }
                break block2;
            }
            break;
        }
        this._file.renameTo(this._tmpFile);
        File bakFile = new File(this._logOptions.getFilePath() + ".bak");
        if (bakFile.exists()) {
            bakFile.delete();
        }
        FileUtils.writeBytes(this._bakFile.getPath(), firstHalf, 0, halfSize);
        if (null != lastEntryDate) {
            this._bakFile.setLastModified(lastEntryDate.getTime());
        }
        FileUtils.copyfile(this._tmpFile, halfSize, this._file, 0);
        this._tmpFile.delete();
        long elapsed = System.currentTimeMillis() - start;
        System.out.println(String.format("took %lld to create half bak file for %s", elapsed, this._file.getPath()));
    }
}

