/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker.schedules.rules;

import com.integ.janoslib.messagepump.MessagePumpEngine;
import com.integ.tasker.schedules.Schedule;
import com.integ.tasker.schedules.rules.DailyDateRule;
import com.integ.tasker.schedules.rules.DateRuleBase;
import com.integ.tasker.schedules.rules.OneTimeDateRule;
import com.integ.tasker.schedules.rules.WeeklyDateRule;
import com.integ.tasker.web.messages.ErrorMessage;
import java.util.Json;

public class DateRuleFactory {
    public static DateRuleBase getRule(Json dateOptionsJson) {
        try {
            Schedule.LOG.info("loading Date Rule from " + dateOptionsJson);
            String dateRecurranceType = dateOptionsJson.getString("DateRecurranceType");
            System.out.println("dateRecurranceType: " + dateRecurranceType);
            switch (dateRecurranceType) {
                case "Daily": {
                    return new DailyDateRule(dateOptionsJson);
                }
                case "Weekly": {
                    return new WeeklyDateRule(dateOptionsJson);
                }
                case "None": {
                    return new OneTimeDateRule(dateOptionsJson);
                }
            }
        }
        catch (Throwable ex) {
            Throwable throwable = new Exception("unable to load date rule: " + dateOptionsJson).initCause(ex);
            Schedule.LOG.error(throwable);
            ErrorMessage message = new ErrorMessage(throwable);
            MessagePumpEngine.postMessage(message.build());
        }
        return null;
    }
}

