/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker.tasks.actions.other;

import com.integ.janoslib.messagepump.MessagePumpEngine;
import com.integ.tasker.tasks.Task;
import com.integ.tasker.tasks.TaskRuntime;
import com.integ.tasker.tasks.actions.Action;
import com.integ.tasker.webhandlers.ErrorMessage;
import com.integpg.janoslib.io.AppLog;
import java.io.File;
import java.io.IOException;
import java.util.Json;

public class FileDeleteMethod
extends Action {
    private final String _filename;

    public FileDeleteMethod(Task parentTask, Json json) {
        super(parentTask, json);
        this._filename = this._paramsJson.getString("Filename");
    }

    @Override
    public void execute(TaskRuntime taskRuntime) throws Throwable {
        try {
            File file = new File(this._filename);
            if (file.exists()) {
                AppLog.info(String.format("deleting %s", this._filename));
                file.delete();
            }
        }
        catch (Throwable ex) {
            AppLog.error(ex);
            ErrorMessage message = new ErrorMessage(ex);
            MessagePumpEngine.postMessage(message.build());
            throw new IOException("Error deleting file: " + this._filename).initCause(ex);
        }
    }
}

