/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker.triggers;

import com.integ.tasker.signals.SignalProfile;
import com.integ.tasker.triggers.DeviceReader;
import com.integ.tasker.triggers.DeviceSignalDictionary;
import com.integ.tasker.triggers.Trigger;
import com.integpg.janoslib.externalio.ExternalModule;
import java.util.Json;

class AnalogTrigger
extends Trigger {
    private final SignalProfile _triggerSignalProfile;
    private final ExternalModule _triggerDevice;
    private final String _triggerComparator;
    private final double _triggerValue;

    public AnalogTrigger(SignalProfile triggerSignalProfile, Json triggerJson) {
        this._triggerSignalProfile = triggerSignalProfile;
        System.out.println("triggerJson: " + triggerJson);
        this._triggerDevice = DeviceSignalDictionary.get(this._triggerSignalProfile.DeviceType);
        System.out.println("_triggerDevice: " + this._triggerDevice);
        this._triggerComparator = triggerJson.getString("Comparator");
        System.out.println("_triggerComparator: " + this._triggerComparator);
        this._triggerValue = triggerJson.getDouble("Value");
        System.out.println("_triggerValue: " + this._triggerValue);
    }

    @Override
    public boolean checkForTrigger() throws Throwable {
        if (null != this._triggerDevice) {
            DeviceReader.readDevice(this._triggerDevice);
            double value = Double.NaN;
            try {
                value = (Double)this._triggerDevice.get(this._triggerSignalProfile.FieldName);
            }
            catch (Exception ex) {
                ex.printStackTrace(System.err);
            }
            System.out.println(" " + value + " " + this._triggerComparator + " " + this._triggerValue);
            boolean triggered = false;
            switch (this._triggerComparator) {
                case "<": {
                    triggered = value < this._triggerValue;
                    break;
                }
                case "<=": {
                    triggered = value <= this._triggerValue;
                    break;
                }
                case "=": {
                    triggered = value == this._triggerValue;
                    break;
                }
                case ">": {
                    triggered = value > this._triggerValue;
                    break;
                }
                case ">=": {
                    triggered = value >= this._triggerValue;
                }
            }
            return triggered;
        }
        return false;
    }

    public String toString() {
        return " will trigger when " + this._triggerComparator + " " + this._triggerValue;
    }
}

