/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker.triggers;

import com.integ.tasker.signals.SignalProfile;
import com.integ.tasker.triggers.DeviceReader;
import com.integ.tasker.triggers.DeviceSignalDictionary;
import com.integ.tasker.triggers.Reset;
import com.integpg.janoslib.externalio.ExternalModule;
import java.util.Json;

class AnalogReset
extends Reset {
    private final SignalProfile _resetSignalProfile;
    private final ExternalModule _resetDevice;
    private String _resetComparator;
    private final double _resetValue;

    public AnalogReset(SignalProfile triggerSignalProfile, Json triggerJson) {
        this._resetSignalProfile = triggerSignalProfile;
        System.out.println("triggerJson: " + triggerJson);
        this._resetDevice = DeviceSignalDictionary.get(this._resetSignalProfile.DeviceType);
        System.out.println("_resetDevice: " + this._resetDevice);
        this._resetComparator = triggerJson.getString("Comparator");
        System.out.println("_resetComparator: " + this._resetComparator);
        this._resetValue = triggerJson.getDouble("Value");
        System.out.println("_resetValue: " + this._resetValue);
    }

    @Override
    public void makeReset() {
        switch (this._resetComparator) {
            case "<": {
                this._resetComparator = ">=";
                break;
            }
            case "<=": {
                this._resetComparator = ">";
                break;
            }
            case "=": {
                this._resetComparator = "!=";
                break;
            }
            case ">": {
                this._resetComparator = "<=";
                break;
            }
            case ">=": {
                this._resetComparator = "<";
            }
        }
    }

    @Override
    public boolean checkForReset() throws Throwable {
        if (null != this._resetDevice) {
            DeviceReader.readDevice(this._resetDevice);
            double value = Double.NaN;
            try {
                value = this._resetDevice.get(this._resetSignalProfile.FieldName);
            }
            catch (Exception ex) {
                ex.printStackTrace(System.err);
            }
            System.out.println(" " + value + " " + this._resetComparator + " " + this._resetValue);
            boolean triggered = false;
            switch (this._resetComparator) {
                case "<": {
                    triggered = value < this._resetValue;
                    break;
                }
                case "<=": {
                    triggered = value <= this._resetValue;
                    break;
                }
                case "=": {
                    triggered = value == this._resetValue;
                    break;
                }
                case "!=": {
                    triggered = value != this._resetValue;
                    break;
                }
                case ">": {
                    triggered = value > this._resetValue;
                    break;
                }
                case ">=": {
                    triggered = value >= this._resetValue;
                }
            }
            return triggered;
        }
        return false;
    }

    public String toString() {
        return " will reset when " + this._resetComparator + " " + this._resetValue;
    }
}

