/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker;

import com.integ.janoslib.messagepump.MessagePumpEngine;
import com.integ.tasker.devices.DeviceConfiguration;
import com.integ.tasker.loggers.LogProfilesCollection;
import com.integ.tasker.loggers.LoggerConfiguration;
import com.integ.tasker.schedules.ScheduleConfiguration;
import com.integ.tasker.signals.SignalConfiguration;
import com.integ.tasker.signals.SignalProfilesCollection;
import com.integ.tasker.tasks.TaskConfiguration;
import com.integ.tasker.triggers.TriggerConfiguration;
import com.integ.tasker.webhandlers.ErrorMessage;
import com.integ.tasker.webhandlers.TasksLoadedMessage;
import com.integpg.janoslib.logger.FileLog;
import com.integpg.janoslib.logger.LogOptions;
import com.integpg.janoslib.logger.LogTypes;
import com.integpg.janoslib.logger.Logger;
import com.integpg.janoslib.system.Application;
import com.integpg.janoslib.utils.FileUtils;
import com.integpg.janoslib.utils.StringUtils;
import java.io.File;
import java.util.Json;

public class WorkspaceConfigurationFile {
    private static final Logger LOG = FileLog.getLog(new LogOptions(Application.getAppName() + "_workspaces.log").setLogType(LogTypes.HalfBak));
    private final String _configurationFilePath;
    private final File _configurationFile;
    private final TaskConfiguration _taskConfiguration = new TaskConfiguration(this);
    private final DeviceConfiguration _deviceConfiguration = new DeviceConfiguration(this);
    private final SignalConfiguration _signalConfiguration = new SignalConfiguration(this);
    private final TriggerConfiguration _triggerConfiguration = new TriggerConfiguration(this);
    private final ScheduleConfiguration _scheduleConfiguration = new ScheduleConfiguration(this);
    private final LoggerConfiguration _loggerConfiguration = new LoggerConfiguration(this);
    private String _version;

    public WorkspaceConfigurationFile(File configurationFile) {
        String configurationFilePath = configurationFile.getPath();
        if (configurationFilePath.contains(" ")) {
            LOG.warn("space(s) found in workspace name: " + configurationFilePath);
            configurationFilePath = StringUtils.replaceAll(configurationFilePath, " ", "_");
            File newFile = new File(configurationFilePath);
            configurationFile.renameTo(newFile);
            configurationFile = newFile;
        }
        this._configurationFile = configurationFile;
        this._configurationFilePath = configurationFile.getPath();
    }

    public File getFile() {
        return this._configurationFile;
    }

    public String getName() {
        return this._configurationFile.getName();
    }

    public void load() {
        long start = System.currentTimeMillis();
        try {
            String fileContents = FileUtils.readAllText(this._configurationFilePath);
            Json workspaceJsonConfig = new Json(fileContents);
            System.out.println("workspaceJsonConfig: " + workspaceJsonConfig);
            this._version = workspaceJsonConfig.getString("Version");
            LOG.info(String.format("loading %s version %s", this._configurationFilePath, this._version));
            Json[] taskList = (Json[])workspaceJsonConfig.get("TaskList");
            this._taskConfiguration.loadConfiguration(taskList);
            Json[] deviceList = (Json[])workspaceJsonConfig.get("DeviceList");
            this._deviceConfiguration.loadConfiguration(deviceList);
            Json[] signalList = (Json[])workspaceJsonConfig.get("SignalList");
            this._signalConfiguration.loadConfiguration(signalList);
            Json[] triggerList = (Json[])workspaceJsonConfig.get("TriggerList");
            this._triggerConfiguration.loadConfiguration(triggerList);
            Json[] scheduleList = (Json[])workspaceJsonConfig.get("ScheduleList");
            this._scheduleConfiguration.loadConfiguration(scheduleList);
            Json[] loggerList = (Json[])workspaceJsonConfig.get("LoggerList");
            this._loggerConfiguration.loadConfiguration(loggerList);
            long elapsed = System.currentTimeMillis() - start;
            double elapsedSeconds = (double)elapsed / 1000.0;
            LOG.info(String.format("loaded %s in %.2f seconds", this._configurationFilePath, elapsedSeconds));
            TasksLoadedMessage message = new TasksLoadedMessage(this._configurationFile.getName(), elapsedSeconds);
            MessagePumpEngine.postMessage(message.build());
        }
        catch (Throwable ex) {
            LOG.error("error loading " + this._configurationFilePath, ex);
            ErrorMessage message = new ErrorMessage(ex);
            MessagePumpEngine.postMessage(message.build());
        }
    }

    public void reload() {
        this.stop();
        this.load();
    }

    public void stop() {
    }

    public SignalProfilesCollection getSignalProfilesCollection() {
        return this._signalConfiguration.getSignalProfilesCollection();
    }

    public LogProfilesCollection getLoggerProfileCollection() {
        return this._loggerConfiguration.getLogProfilesCollection();
    }
}

