/*
 * Decompiled with CFR 0.152.
 */
package com.integ.scripting.objects;

import com.integ.scripting.ExpressionEngine;
import com.integ.scripting.exceptions.ScriptParserException;
import com.integ.scripting.nodes.AbstractNode;
import com.integ.scripting.objects.AbstractObject;
import com.integ.scripting.objects.EnvironObject;
import com.integ.scripting.objects.FourTwentyInputObject;
import com.integ.scripting.objects.FourTwentyOutputObject;
import com.integ.scripting.objects.TempProbeObject;
import com.integ.scripting.objects.TenVoltInputObject;
import com.integ.scripting.objects.TenVoltOutputObject;
import com.integ.tasker.signals.SignalProfile;
import com.integ.tasker.signals.SignalProfilesCollection;
import com.integ.tasker.tasks.Scope;

class SignalProfileObject
extends AbstractObject {
    private final String _variableName;

    SignalProfileObject(String variableName) {
        this._variableName = variableName;
    }

    @Override
    public AbstractNode parse(ExpressionEngine parser) throws ScriptParserException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Object execute(Scope scope) {
        SignalProfile signalProfile = SignalProfilesCollection.GLOBAL.getByName(this._variableName);
        System.out.println("signalProfile = " + signalProfile);
        System.out.println("signalProfile.DeviceType = " + signalProfile.DeviceType);
        String deviceType = signalProfile.DeviceType;
        int channel = signalProfile.Channel;
        String fieldName = signalProfile.FieldName;
        if ("type28".equalsIgnoreCase(deviceType)) {
            Object result = TempProbeObject.read(channel, fieldName);
            System.out.println("result = " + result);
            return result;
        }
        if ("vin".equalsIgnoreCase(deviceType)) {
            Object result = TenVoltInputObject.read(channel, fieldName);
            System.out.println("result = " + result);
            return result;
        }
        if ("vout".equalsIgnoreCase(deviceType)) {
            Object result = TenVoltOutputObject.read(channel, fieldName);
            System.out.println("result = " + result);
            return result;
        }
        if ("iin".equalsIgnoreCase(deviceType)) {
            Object result = FourTwentyInputObject.read(channel, fieldName);
            System.out.println("result = " + result);
            return result;
        }
        if ("iout".equalsIgnoreCase(deviceType)) {
            Object result = FourTwentyOutputObject.read(channel, fieldName);
            System.out.println("result = " + result);
            return result;
        }
        if ("type7e".equalsIgnoreCase(deviceType)) {
            Object result = EnvironObject.read(channel, fieldName);
            System.out.println("result = " + result);
            return result;
        }
        String deviceString = String.format("{{%s[%d].%s}}", deviceType, channel + 1, fieldName);
        System.out.println("deviceString: " + deviceString);
        return signalProfile.toString();
    }
}

