/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker.triggers.triggertypes;

import com.integ.tasker.Unloadable;
import com.integ.tasker.devices.DeviceCollection;
import com.integ.tasker.devices.DeviceProfile;
import com.integ.tasker.devices.TCPServerDevice;
import com.integ.tasker.triggers.Trigger;
import com.integ.tasker.workspaces.WorkspaceFile;
import com.integpg.janoslib.net.tcp.TcpServerEvent;
import com.integpg.janoslib.net.tcp.TcpServerListener;
import java.util.Json;

public class TCPReceiveTrigger
extends Trigger
implements Unloadable,
TcpServerListener {
    private final Json _paramsJson;

    public TCPReceiveTrigger(Json triggerJson) {
        this._paramsJson = (Json)triggerJson.get("Params");
        System.out.println("add tcp receive trigger");
        String deviceGuid = this._paramsJson.getString("DeviceGUID");
        DeviceProfile device = DeviceCollection.GLOBAL.getByDeviceGUID(deviceGuid);
        if (null == device) {
            throw new RuntimeException("No device found for " + deviceGuid);
        }
        if (!(device instanceof TCPServerDevice)) {
            throw new RuntimeException("Device found for " + deviceGuid + " is not an TCP Server Device");
        }
        TCPServerDevice tCPServerDevice = (TCPServerDevice)device;
        tCPServerDevice.setListener(this);
    }

    @Override
    public void setWorkspaceConfigurationFile(WorkspaceFile workspaceConfigurationFile) {
        super.setWorkspaceConfigurationFile(workspaceConfigurationFile);
        this._workspaceConfigurationFile.addUnloadable(this);
    }

    @Override
    public void unload() {
    }

    @Override
    public void clientConnected(TcpServerEvent evt) {
        this.trigger();
    }
}

