/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker;

import com.integ.tasker.tasks.Task;
import com.integ.tasker.tasks.TaskCollection;
import com.integpg.janoslib.logging.Logger;
import com.integpg.janoslib.system.Application;
import com.integpg.janoslib.text.QuickDateFormat;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class TaskerAsciiCommandClient
implements Runnable {
    private static final Logger LOG = Logger.getLogger(String.format("/%s_AsciiCommandClient.log", Application.getAppName()));
    private static final QuickDateFormat QUICK_DATE_FORMAT = QuickDateFormat.getDefault();
    private static final Pattern COMMAND_PATTERN = Pattern.compile("(\\w+\\.\\w+) ([\\w \\.\\-_\\(\\)]+)$", 1);
    private final String _clientInfo;
    private final InputStream _inputStream;
    private final OutputStream _outputStream;
    private final StringBuffer _stringBuffer = new StringBuffer();
    private Thread _thread = null;

    public TaskerAsciiCommandClient(String clientInfo, InputStream inputStream, OutputStream outputStream) {
        this._clientInfo = clientInfo;
        this._inputStream = inputStream;
        this._outputStream = outputStream;
    }

    public void start() {
        if (null == this._thread) {
            this._thread = new Thread(this);
            this._thread.setName(this.getClass().getName());
            this._thread.setDaemon(true);
            this._thread.start();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        System.out.println(String.format("%s handle connection at %s", this._clientInfo, QUICK_DATE_FORMAT.format()));
        byte[] buffer = new byte[1024];
        try {
            while (null != this._inputStream) {
                int bytesRead = this._inputStream.read(buffer);
                System.out.println(String.format("<-- %d bytes read", bytesRead));
                if (-1 == bytesRead) {
                    throw new IOException();
                }
                try {
                    String asciiData = new String(buffer, 0, bytesRead);
                    System.out.println(String.format("<-- %d bytes: %s", bytesRead, asciiData));
                    this._stringBuffer.append(asciiData);
                    int semicolonPos = -1;
                    while (-1 != (semicolonPos = this._stringBuffer.indexOf("\n"))) {
                        String message = this._stringBuffer.substring(0, semicolonPos);
                        this._stringBuffer.delete(0, semicolonPos + 1);
                        this.processMessage(message);
                    }
                }
                catch (Exception ex) {
                    LOG.error("error processing read bytes", ex);
                }
            }
            return;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            try {
                this._inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            LOG.error("error in run()", ex);
        }
    }

    private void processMessage(String message) {
        try {
            message = message.trim();
            LOG.info(String.format("%s received: %s", this._clientInfo, message));
            Matcher match = COMMAND_PATTERN.matcher(message);
            boolean found = match.find();
            System.out.println("COMMAND_PATTERN.find(): " + found);
            if (found) {
                System.out.println("matcher.groupCount(): " + match.groupCount());
                for (int i = 0; i < match.groupCount(); ++i) {
                    System.out.println("  matcher.group[" + i + "]: " + match.group(i));
                }
                this.processCommand(match);
            } else {
                this._outputStream.write(String.format("invalid command: %s\r\n", message).getBytes());
            }
            this._outputStream.flush();
        }
        catch (Exception ex) {
            LOG.error("error processing read bytes", ex);
        }
    }

    private void processCommand(Matcher match) {
        block8: {
            try {
                String command = match.group(1);
                System.out.println("command: " + command);
                if (!command.equalsIgnoreCase("task.execute")) break block8;
                if (3 == match.groupCount()) {
                    String taskName = match.group(2);
                    System.out.println("functionNameString: " + taskName);
                    if (TaskCollection.GLOBAL.containsTaskName(taskName)) {
                        Task task = TaskCollection.GLOBAL.getByTaskName(taskName);
                        if (null == task) break block8;
                        try {
                            LOG.info(String.format("%s executing %s", this._clientInfo, taskName));
                            this._outputStream.write(String.format("executing \"%s\"\r\n", taskName).getBytes());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        task.execute(String.format("AsciiClient: %s", this._clientInfo));
                        break block8;
                    }
                    try {
                        LOG.info(String.format("%s task \"%s\" was not found", this._clientInfo, taskName));
                        this._outputStream.write(String.format("task \"%s\" was not found\r\n", taskName).getBytes());
                    }
                    catch (Exception exception) {}
                    break block8;
                }
                throw new RuntimeException("incorrect number of arguments for " + command);
            }
            catch (Throwable ex) {
                LOG.error("error processing command", ex);
            }
        }
    }
}

